/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shaded.com.google.common.collect.ImmutableSet;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class UpdateReaderGroupEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String rgName;
    private final long requestId;
    private UUID readerGroupId;
    private long generation;
    private boolean isTransitionToFromSubscriber;
    private ImmutableSet<String> removeStreams;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.rgName);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processUpdateReaderGroup(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static UpdateReaderGroupEventBuilder builder() {
        return new UpdateReaderGroupEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRgName() {
        return this.rgName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getReaderGroupId() {
        return this.readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGeneration() {
        return this.generation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTransitionToFromSubscriber() {
        return this.isTransitionToFromSubscriber;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableSet<String> getRemoveStreams() {
        return this.removeStreams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReaderGroupId(UUID readerGroupId) {
        this.readerGroupId = readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGeneration(long generation) {
        this.generation = generation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTransitionToFromSubscriber(boolean isTransitionToFromSubscriber) {
        this.isTransitionToFromSubscriber = isTransitionToFromSubscriber;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRemoveStreams(ImmutableSet<String> removeStreams) {
        this.removeStreams = removeStreams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateReaderGroupEvent)) {
            return false;
        }
        UpdateReaderGroupEvent other = (UpdateReaderGroupEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$rgName = this.getRgName();
        String other$rgName = other.getRgName();
        if (this$rgName == null ? other$rgName != null : !this$rgName.equals(other$rgName)) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        UUID this$readerGroupId = this.getReaderGroupId();
        UUID other$readerGroupId = other.getReaderGroupId();
        if (this$readerGroupId == null ? other$readerGroupId != null : !((Object)this$readerGroupId).equals(other$readerGroupId)) {
            return false;
        }
        if (this.getGeneration() != other.getGeneration()) {
            return false;
        }
        if (this.isTransitionToFromSubscriber() != other.isTransitionToFromSubscriber()) {
            return false;
        }
        ImmutableSet<String> this$removeStreams = this.getRemoveStreams();
        ImmutableSet<String> other$removeStreams = other.getRemoveStreams();
        return !(this$removeStreams == null ? other$removeStreams != null : !((Object)this$removeStreams).equals(other$removeStreams));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateReaderGroupEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $rgName = this.getRgName();
        result = result * 59 + ($rgName == null ? 43 : $rgName.hashCode());
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        UUID $readerGroupId = this.getReaderGroupId();
        result = result * 59 + ($readerGroupId == null ? 43 : ((Object)$readerGroupId).hashCode());
        long $generation = this.getGeneration();
        result = result * 59 + (int)($generation >>> 32 ^ $generation);
        result = result * 59 + (this.isTransitionToFromSubscriber() ? 79 : 97);
        ImmutableSet<String> $removeStreams = this.getRemoveStreams();
        result = result * 59 + ($removeStreams == null ? 43 : ((Object)$removeStreams).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "UpdateReaderGroupEvent(scope=" + this.getScope() + ", rgName=" + this.getRgName() + ", requestId=" + this.getRequestId() + ", readerGroupId=" + this.getReaderGroupId() + ", generation=" + this.getGeneration() + ", isTransitionToFromSubscriber=" + this.isTransitionToFromSubscriber() + ", removeStreams=" + this.getRemoveStreams() + ")";
    }

    @ConstructorProperties(value={"scope", "rgName", "requestId", "readerGroupId", "generation", "isTransitionToFromSubscriber", "removeStreams"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UpdateReaderGroupEvent(String scope, String rgName, long requestId, UUID readerGroupId, long generation, boolean isTransitionToFromSubscriber, ImmutableSet<String> removeStreams) {
        this.scope = scope;
        this.rgName = rgName;
        this.requestId = requestId;
        this.readerGroupId = readerGroupId;
        this.generation = generation;
        this.isTransitionToFromSubscriber = isTransitionToFromSubscriber;
        this.removeStreams = removeStreams;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<UpdateReaderGroupEvent, UpdateReaderGroupEventBuilder> {
        @Override
        protected UpdateReaderGroupEventBuilder newBuilder() {
            return UpdateReaderGroupEvent.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(UpdateReaderGroupEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.rgName);
            target.writeLong(e.requestId);
            target.writeUUID(e.readerGroupId);
            target.writeLong(e.generation);
            target.writeBoolean(e.isTransitionToFromSubscriber);
            target.writeCollection(e.removeStreams, DataOutput::writeUTF);
        }

        private void read00(RevisionDataInput source, UpdateReaderGroupEventBuilder eb) throws IOException {
            eb.scope(source.readUTF());
            eb.rgName(source.readUTF());
            eb.requestId(source.readLong());
            eb.readerGroupId(source.readUUID());
            eb.generation(source.readLong());
            eb.isTransitionToFromSubscriber(source.readBoolean());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            source.readCollection(DataInput::readUTF, builder);
            eb.removeStreams((ImmutableSet<String>)builder.build());
        }
    }

    private static class UpdateReaderGroupEventBuilder
    implements ObjectBuilder<UpdateReaderGroupEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String rgName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID readerGroupId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long generation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean isTransitionToFromSubscriber;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableSet<String> removeStreams;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        UpdateReaderGroupEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder rgName(String rgName) {
            this.rgName = rgName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder readerGroupId(UUID readerGroupId) {
            this.readerGroupId = readerGroupId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder generation(long generation) {
            this.generation = generation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder isTransitionToFromSubscriber(boolean isTransitionToFromSubscriber) {
            this.isTransitionToFromSubscriber = isTransitionToFromSubscriber;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEventBuilder removeStreams(ImmutableSet<String> removeStreams) {
            this.removeStreams = removeStreams;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateReaderGroupEvent build() {
            return new UpdateReaderGroupEvent(this.scope, this.rgName, this.requestId, this.readerGroupId, this.generation, this.isTransitionToFromSubscriber, this.removeStreams);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "UpdateReaderGroupEvent.UpdateReaderGroupEventBuilder(scope=" + this.scope + ", rgName=" + this.rgName + ", requestId=" + this.requestId + ", readerGroupId=" + this.readerGroupId + ", generation=" + this.generation + ", isTransitionToFromSubscriber=" + this.isTransitionToFromSubscriber + ", removeStreams=" + this.removeStreams + ")";
        }
    }
}

