/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event.kvtable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.kvtable.TableRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class DeleteTableEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String kvtName;
    private final long requestId;
    private final UUID tableId;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.kvtName);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((TableRequestProcessor)processor).processDeleteKVTable(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DeleteTableEventBuilder builder() {
        return new DeleteTableEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKvtName() {
        return this.kvtName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getTableId() {
        return this.tableId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteTableEvent)) {
            return false;
        }
        DeleteTableEvent other = (DeleteTableEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$kvtName = this.getKvtName();
        String other$kvtName = other.getKvtName();
        if (this$kvtName == null ? other$kvtName != null : !this$kvtName.equals(other$kvtName)) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        UUID this$tableId = this.getTableId();
        UUID other$tableId = other.getTableId();
        return !(this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeleteTableEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $kvtName = this.getKvtName();
        result = result * 59 + ($kvtName == null ? 43 : $kvtName.hashCode());
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        UUID $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DeleteTableEvent(scope=" + this.getScope() + ", kvtName=" + this.getKvtName() + ", requestId=" + this.getRequestId() + ", tableId=" + this.getTableId() + ")";
    }

    @ConstructorProperties(value={"scope", "kvtName", "requestId", "tableId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DeleteTableEvent(String scope, String kvtName, long requestId, UUID tableId) {
        this.scope = scope;
        this.kvtName = kvtName;
        this.requestId = requestId;
        this.tableId = tableId;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<DeleteTableEvent, DeleteTableEventBuilder> {
        @Override
        protected DeleteTableEventBuilder newBuilder() {
            return DeleteTableEvent.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(DeleteTableEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.kvtName);
            target.writeLong(e.requestId);
            target.writeUUID(e.tableId);
        }

        private void read00(RevisionDataInput source, DeleteTableEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.kvtName(source.readUTF());
            b.requestId(source.readLong());
            b.tableId(source.readUUID());
        }
    }

    private static class DeleteTableEventBuilder
    implements ObjectBuilder<DeleteTableEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String kvtName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID tableId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DeleteTableEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteTableEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteTableEventBuilder kvtName(String kvtName) {
            this.kvtName = kvtName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteTableEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteTableEventBuilder tableId(UUID tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteTableEvent build() {
            return new DeleteTableEvent(this.scope, this.kvtName, this.requestId, this.tableId);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DeleteTableEvent.DeleteTableEventBuilder(scope=" + this.scope + ", kvtName=" + this.kvtName + ", requestId=" + this.requestId + ", tableId=" + this.tableId + ")";
        }
    }
}

