/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.com.google.common.base.Strings;
import lombok.Generated;

public enum ClientMetricKeys {
    CLIENT_APPEND_LATENCY("client.segment.append_latency_ms"),
    CLIENT_APPEND_BLOCK_SIZE("client.segment.append_block_size"),
    CLIENT_OUTSTANDING_APPEND_COUNT("client.segment.outstanding_append_count");

    @VisibleForTesting
    private final String metricKey;

    private ClientMetricKeys(String metricKey) {
        StringBuilder sb = new StringBuilder("pravega");
        sb.append(".");
        this.metricKey = sb.append(metricKey).toString();
    }

    public String metric(String ... tags) {
        if (tags == null || tags.length == 0) {
            return this.metricKey;
        }
        StringBuilder sb = new StringBuilder(this.metricKey);
        Preconditions.checkArgument(tags.length % 2 == 0, "Tags is a set of key/value pair so the size must be even: %s", tags.length);
        for (int i = 0; i < tags.length; i += 2) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(tags[i]) && !Strings.isNullOrEmpty(tags[i + 1]), "Tag name or value cannot be empty or null");
            sb.append('.').append(tags[i + 1]);
        }
        return sb.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMetricKey() {
        return this.metricKey;
    }
}

