/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import io.pravega.shaded.io.netty.channel.ChannelHandlerContext;
import io.pravega.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import io.pravega.shared.protocol.netty.Append;
import io.pravega.shared.protocol.netty.CommandDecoder;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.protocol.netty.WireCommands;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendDecoder
extends MessageToMessageDecoder<WireCommand> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppendDecoder.class);
    private final HashMap<UUID, Segment> appendingSegments = new HashMap();
    private WireCommands.AppendBlock currentBlock;

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof WireCommands.SetupAppend || msg instanceof WireCommands.AppendBlock || msg instanceof WireCommands.AppendBlockEnd || msg instanceof WireCommands.Padding || msg instanceof WireCommands.ConditionalAppend || msg instanceof WireCommands.ConditionalBlockEnd;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WireCommand command, List<Object> out) throws Exception {
        Request result = this.processCommand(command);
        if (result != null) {
            out.add(result);
        }
    }

    @VisibleForTesting
    Request processCommand(WireCommand command) throws InvalidMessageException, IOException {
        try {
            return this.processCommandInternal(command);
        }
        catch (Throwable ex) {
            if (command instanceof WireCommands.ReleasableCommand) {
                ((WireCommands.ReleasableCommand)command).release();
            }
            if (this.currentBlock != null) {
                this.currentBlock.release();
                this.currentBlock = null;
            }
            throw ex;
        }
    }

    private Request processCommandInternal(WireCommand command) throws InvalidMessageException, IOException {
        if (this.currentBlock != null && command.getType() != WireCommandType.APPEND_BLOCK_END) {
            log.warn("Invalid message received {}. CurrentBlock {}", (Object)command, (Object)this.currentBlock);
            throw new InvalidMessageException("Unexpected " + (Object)((Object)command.getType()) + " following a append block.");
        }
        Request result = null;
        switch (command.getType()) {
            case PADDING: {
                break;
            }
            case SETUP_APPEND: {
                result = this.processSetupAppend((WireCommands.SetupAppend)command);
                break;
            }
            case CONDITIONAL_APPEND: {
                result = this.processConditionalAppend((WireCommands.ConditionalAppend)command);
                break;
            }
            case APPEND_BLOCK: {
                this.processAppendBlock((WireCommands.AppendBlock)command);
                break;
            }
            case APPEND_BLOCK_END: {
                result = this.processAppendBlockEnd((WireCommands.AppendBlockEnd)command);
                break;
            }
            case CONDITIONAL_BLOCK_END: {
                result = this.processConditionalBlockEnd((WireCommands.ConditionalBlockEnd)command);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected case: " + command);
            }
        }
        return result;
    }

    private WireCommands.SetupAppend processSetupAppend(WireCommands.SetupAppend setup) {
        this.appendingSegments.put(setup.getWriterId(), new Segment(setup.getSegment()));
        return setup;
    }

    private Append processConditionalAppend(WireCommands.ConditionalAppend ca) {
        Segment segment = this.getSegment(ca.getWriterId());
        if (ca.getEventNumber() < segment.lastEventNumber) {
            throw new InvalidMessageException("Last event number went backwards.");
        }
        segment.lastEventNumber = ca.getEventNumber();
        return new Append(segment.getName(), ca.getWriterId(), ca.getEventNumber(), 1, ca.getEvent().getAsByteBuf(), ca.getExpectedOffset(), ca.getRequestId());
    }

    private void processAppendBlock(WireCommands.AppendBlock appendBlock) {
        this.currentBlock = appendBlock;
        this.getSegment(this.currentBlock.getWriterId());
    }

    private Append processAppendBlockEnd(WireCommands.AppendBlockEnd blockEnd) throws InvalidMessageException, IOException {
        ByteBuf appendDataBuf;
        UUID writerId = blockEnd.getWriterId();
        Segment segment = this.getSegment(writerId);
        int sizeOfWholeEventsInBlock = blockEnd.getSizeOfWholeEvents();
        if (blockEnd.numEvents <= 0) {
            throw new InvalidMessageException("Invalid number of events in block. numEvents : " + blockEnd.numEvents);
        }
        if (blockEnd.getLastEventNumber() < segment.lastEventNumber) {
            throw new InvalidMessageException(String.format("Last event number went backwards, Segment last Event number : %d , Append block End Event number : %d,for writer ID: %s and Segment Name: %s", segment.lastEventNumber, blockEnd.getLastEventNumber(), writerId, segment.name));
        }
        if (this.currentBlock != null) {
            if (!this.currentBlock.getWriterId().equals(writerId)) {
                throw new InvalidMessageException(String.format("Writer ID mismatch between Append Block and Append block End, Append block Writer ID : %s, Append block End Writer ID: %s", this.currentBlock.getWriterId(), writerId));
            }
            if (sizeOfWholeEventsInBlock > this.currentBlock.getData().readableBytes() || sizeOfWholeEventsInBlock < 0) {
                throw new InvalidMessageException(String.format("Invalid SizeOfWholeEvents in block : %d, Append block data bytes : %d", sizeOfWholeEventsInBlock, this.currentBlock.getData().readableBytes()));
            }
            appendDataBuf = this.getAppendDataBuf(blockEnd, sizeOfWholeEventsInBlock);
        } else {
            appendDataBuf = blockEnd.getData();
        }
        if (appendDataBuf == null) {
            throw new InvalidMessageException("Invalid data in block");
        }
        segment.lastEventNumber = blockEnd.getLastEventNumber();
        this.currentBlock = null;
        return new Append(segment.name, writerId, segment.lastEventNumber, blockEnd.numEvents, appendDataBuf, null, blockEnd.getRequestId());
    }

    private Append processConditionalBlockEnd(WireCommands.ConditionalBlockEnd ca) {
        Segment segment = this.getSegment(ca.getWriterId());
        if (ca.getEventNumber() < segment.lastEventNumber) {
            throw new InvalidMessageException("Last event number went backwards.");
        }
        segment.lastEventNumber = ca.getEventNumber();
        return new Append(segment.getName(), ca.getWriterId(), ca.getEventNumber(), 1, ca.getData(), ca.getExpectedOffset(), ca.getRequestId());
    }

    private ByteBuf getAppendDataBuf(WireCommands.AppendBlockEnd blockEnd, int sizeOfWholeEventsInBlock) throws IOException {
        ByteBuf appendDataBuf = this.currentBlock.getData().slice(0, sizeOfWholeEventsInBlock);
        int remaining = this.currentBlock.getData().readableBytes() - sizeOfWholeEventsInBlock;
        if (remaining > 0) {
            ByteBuf dataRemainingInBlock = this.currentBlock.getData().slice(sizeOfWholeEventsInBlock, remaining);
            WireCommand cmd = CommandDecoder.parseCommand(dataRemainingInBlock);
            if (cmd.getType() != WireCommandType.PARTIAL_EVENT && cmd.getType() != WireCommandType.PADDING) {
                throw new InvalidMessageException("Found " + (Object)((Object)cmd.getType()) + " at end of append block but was expecting a partialEvent or padding.");
            }
            if (cmd.getType() == WireCommandType.PADDING && blockEnd.getData().readableBytes() != 0) {
                throw new InvalidMessageException("Unexpected data in BlockEnd");
            }
            if (cmd.getType() == WireCommandType.PARTIAL_EVENT) {
                if (appendDataBuf.readableBytes() == 0) {
                    this.currentBlock.release();
                    appendDataBuf = Unpooled.wrappedUnmodifiableBuffer(((WireCommands.PartialEvent)cmd).getData(), blockEnd.getData());
                } else {
                    appendDataBuf = Unpooled.wrappedUnmodifiableBuffer(appendDataBuf, ((WireCommands.PartialEvent)cmd).getData(), blockEnd.getData());
                }
            }
        }
        return appendDataBuf;
    }

    private Segment getSegment(UUID writerId) {
        Segment segment = this.appendingSegments.get(writerId);
        if (segment == null) {
            throw new InvalidMessageException("ConnectionID refrenced before SetupAppend");
        }
        return segment;
    }

    private static final class Segment {
        private final String name;
        private long lastEventNumber;

        @ConstructorProperties(value={"name"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Segment(String name) {
            this.name = name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLastEventNumber() {
            return this.lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setLastEventNumber(long lastEventNumber) {
            this.lastEventNumber = lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLastEventNumber() == other.getLastEventNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $lastEventNumber = this.getLastEventNumber();
            result = result * 59 + (int)($lastEventNumber >>> 32 ^ $lastEventNumber);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AppendDecoder.Segment(name=" + this.getName() + ", lastEventNumber=" + this.getLastEventNumber() + ")";
        }
    }
}

