/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.ByteBufInputStream;
import java.io.IOException;

public class EnhancedByteBufInputStream
extends ByteBufInputStream {
    private final ByteBuf buffer;

    public EnhancedByteBufInputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public ByteBuf readFully(int length) throws IOException {
        Preconditions.checkArgument(length >= 0 && length <= this.available(), "length must a non-negative number less than %s", this.available());
        ByteBuf result = this.buffer.slice(this.buffer.readerIndex(), length);
        this.buffer.readerIndex(this.buffer.readerIndex() + length);
        return result;
    }
}

