/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.security.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthHandlerInput
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordAuthHandlerInput.class);
    private File file;

    public PasswordAuthHandlerInput(String fileName, String extension) {
        Exceptions.checkNotNullOrEmpty(fileName, "fileName");
        Exceptions.checkNotNullOrEmpty(extension, "extension");
        try {
            this.file = File.createTempFile(fileName, extension);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void postEntry(Entry entry) {
        Preconditions.checkNotNull(entry, "Specified entry is null.");
        this.postEntries(Arrays.asList(entry));
    }

    public void postEntries(List<Entry> entries) {
        Exceptions.checkNotNullOrEmpty(entries, "entries");
        try (FileWriter writer = new FileWriter(this.file.getAbsolutePath());){
            entries.forEach(e -> {
                try {
                    writer.write(this.credentialsAndAclString((Entry)e));
                }
                catch (IOException iE) {
                    throw new RuntimeException(iE);
                }
            });
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private String credentialsAndAclString(Entry entry) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(entry.username) && !Strings.isNullOrEmpty(entry.password) && entry.acl != null && !entry.acl.startsWith(":"));
        return String.format("%s:%s:%s%n", entry.username, entry.password, entry.acl);
    }

    @Override
    public void close() {
        try {
            this.file.delete();
        }
        catch (Exception e) {
            log.warn("Unable to delete file", (Throwable)e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public File getFile() {
        return this.file;
    }

    public static class Entry {
        private final String username;
        private final String password;
        private final String acl;

        @ConstructorProperties(value={"username", "password", "acl"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Entry(String username, String password, String acl) {
            this.username = username;
            this.password = password;
            this.acl = acl;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static Entry of(String username, String password, String acl) {
            return new Entry(username, password, acl);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getUsername() {
            return this.username;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPassword() {
            return this.password;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getAcl() {
            return this.acl;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$acl = this.getAcl();
            String other$acl = other.getAcl();
            return !(this$acl == null ? other$acl != null : !this$acl.equals(other$acl));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $acl = this.getAcl();
            result = result * 59 + ($acl == null ? 43 : $acl.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "PasswordAuthHandlerInput.Entry(username=" + this.getUsername() + ", password=" + this.getPassword() + ", acl=" + this.getAcl() + ")";
        }
    }
}

