/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.security.token;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWebToken {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonWebToken.class);
    private final String subject;
    private final String audience;
    private final byte[] signingKey;
    private final Date expirationTime;
    private final Instant currentInstant = Instant.now();
    private final Map<String, Object> permissionsByResource;
    private final SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS512;

    public JsonWebToken(String subject, String audience, byte[] signingKey) {
        this(subject, audience, signingKey, new HashMap<String, Object>(), null);
    }

    public JsonWebToken(@NonNull String subject, @NonNull String audience, @NonNull byte[] signingKey, Map<String, Object> resourcePermissionClaims, Integer timeToLiveInSeconds) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        if (signingKey == null) {
            throw new NullPointerException("signingKey is marked non-null but is null");
        }
        if (timeToLiveInSeconds != null) {
            Preconditions.checkArgument(timeToLiveInSeconds >= -1);
        }
        this.subject = subject;
        this.audience = audience;
        this.signingKey = (byte[])signingKey.clone();
        this.expirationTime = timeToLiveInSeconds != null && timeToLiveInSeconds != -1 ? Date.from(this.currentInstant.plusSeconds(timeToLiveInSeconds.intValue())) : null;
        this.permissionsByResource = resourcePermissionClaims;
    }

    public JsonWebToken(@NonNull String subject, @NonNull String audience, @NonNull byte[] signingKey, Date expiry, Map<String, Object> resourcePermissionClaims) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        if (signingKey == null) {
            throw new NullPointerException("signingKey is marked non-null but is null");
        }
        this.subject = subject;
        this.audience = audience;
        this.signingKey = (byte[])signingKey.clone();
        this.expirationTime = expiry != null ? Date.from(expiry.toInstant()) : null;
        this.permissionsByResource = resourcePermissionClaims;
    }

    public String toCompactString() {
        JwtBuilder builder = Jwts.builder().setSubject(this.subject).setAudience(this.audience).setIssuedAt(Date.from(this.currentInstant));
        if (this.permissionsByResource != null) {
            builder.addClaims(this.permissionsByResource);
        }
        if (this.expirationTime != null) {
            builder.setExpiration(this.expirationTime);
        }
        builder.signWith(this.signatureAlgorithm, this.signingKey);
        return builder.compact();
    }

    public Duration durationToExpiry() {
        if (this.expirationTime == null) {
            return null;
        }
        return Duration.between(this.currentInstant, this.expirationTime.toInstant());
    }

    public static JsonWebToken emptyToken() {
        return new JsonWebToken("empty", "empty", "empty".getBytes());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "JsonWebToken(subject=" + this.getSubject() + ", audience=" + this.getAudience() + ", signingKey=" + Arrays.toString(this.signingKey) + ", expirationTime=" + this.getExpirationTime() + ", currentInstant=" + this.currentInstant + ", permissionsByResource=" + this.getPermissionsByResource() + ", signatureAlgorithm=" + this.signatureAlgorithm + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSubject() {
        return this.subject;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAudience() {
        return this.audience;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getPermissionsByResource() {
        return this.permissionsByResource;
    }
}

