/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.security.token;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.pravega.auth.InvalidTokenException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.com.google.common.base.Strings;
import io.pravega.shared.security.token.JsonWebToken;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtParser {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtParser.class);
    private static final List<String> CLAIMS_TO_FILTER = Arrays.asList("sub", "aud", "exp", "iat");

    public static Set<Map.Entry<String, Object>> fetchClaims(String token, byte[] signingKey) throws TokenExpiredException, InvalidTokenException {
        return JwtParser.parseClaims(token, signingKey).entrySet();
    }

    public static JsonWebToken parse(String token, byte[] signingKey) {
        Claims claims = JwtParser.parseClaims(token, signingKey);
        if (claims == null) {
            throw new InvalidTokenException("Token has no claims.");
        }
        HashMap<String, Object> permissionsByResource = new HashMap<String, Object>();
        claims.entrySet().forEach(entry -> {
            if (!CLAIMS_TO_FILTER.contains(entry.getKey())) {
                permissionsByResource.put((String)entry.getKey(), entry.getValue());
            }
        });
        return new JsonWebToken(claims.getSubject(), claims.getAudience(), signingKey, claims.getExpiration(), permissionsByResource);
    }

    @VisibleForTesting
    static Claims parseClaims(String token, byte[] signingKey) throws TokenExpiredException, InvalidTokenException {
        if (Strings.isNullOrEmpty(token)) {
            throw new InvalidTokenException("Token is null or empty");
        }
        try {
            Jws claimsJws = Jwts.parser().setSigningKey(signingKey).parseClaimsJws(token);
            log.debug("Successfully parsed JWT token.");
            return (Claims)claimsJws.getBody();
        }
        catch (ExpiredJwtException e) {
            throw new TokenExpiredException((Exception)((Object)e));
        }
        catch (JwtException e) {
            throw new InvalidTokenException((Exception)((Object)e));
        }
    }
}

