/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.client.stream.Serializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.ControllerEventSerializer;
import java.nio.ByteBuffer;
import lombok.NonNull;

public class EventSerializer<T extends ControllerEvent>
implements Serializer<T> {
    private final ControllerEventSerializer baseSerializer;

    public EventSerializer() {
        this(new ControllerEventSerializer());
    }

    @VisibleForTesting
    public EventSerializer(@NonNull ControllerEventSerializer baseSerializer) {
        if (baseSerializer == null) {
            throw new NullPointerException("baseSerializer is marked @NonNull but is null");
        }
        this.baseSerializer = baseSerializer;
    }

    public ByteBuffer serialize(T value) {
        return this.baseSerializer.toByteBuffer(value);
    }

    public T deserialize(ByteBuffer serializedValue) {
        return (T)this.baseSerializer.fromByteBuffer(serializedValue);
    }
}

