/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.client.stream.Position;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import io.pravega.shared.controller.event.ControllerEvent;
import java.util.concurrent.CompletableFuture;

public abstract class EventProcessor<T extends ControllerEvent> {
    Checkpointer checkpointer;
    Writer<T> selfWriter;

    protected void beforeStart() {
    }

    protected abstract void process(T var1, Position var2);

    protected void afterStop() {
    }

    protected void beforeRestart(Throwable t, T event) {
    }

    protected Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    @VisibleForTesting
    public Writer<T> getSelfWriter() {
        return this.selfWriter;
    }

    @FunctionalInterface
    public static interface Writer<T extends ControllerEvent> {
        public CompletableFuture<Void> write(T var1);
    }

    @FunctionalInterface
    public static interface Checkpointer {
        public void store(Position var1) throws CheckpointStoreException;
    }
}

