/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.Retry;
import io.pravega.controller.eventProcessor.impl.EventProcessor;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.shared.controller.event.ControllerEvent;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorHelper {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(EventProcessorHelper.class);
    private static final long RETRY_INITIAL_DELAY = 100L;
    private static final int RETRY_MULTIPLIER = 2;
    private static final int RETRY_MAX_ATTEMPTS = 5;
    private static final long RETRY_MAX_DELAY = Duration.ofSeconds(2L).toMillis();
    private static final Retry.RetryAndThrowConditionally RETRY = Retry.withExpBackoff((long)100L, (int)2, (int)5, (long)RETRY_MAX_DELAY).retryWhen(RetryableException::isRetryable);
    private static final Retry.RetryUnconditionally INDEFINITELY = Retry.indefinitelyWithExpBackoff((long)100L, (int)2, (long)RETRY_MAX_DELAY, e -> {
        if (log.isDebugEnabled()) {
            log.debug("error while writing event back into stream {}", e);
        } else {
            log.warn("error while writing event back into stream");
        }
    });

    public static <U> CompletableFuture<U> withRetries(Supplier<CompletableFuture<U>> futureSupplier, ScheduledExecutorService executor) {
        return RETRY.runAsync(futureSupplier, executor);
    }

    public static <U> CompletableFuture<U> indefiniteRetries(Supplier<CompletableFuture<U>> futureSupplier, ScheduledExecutorService executor) {
        return INDEFINITELY.runAsync(futureSupplier, executor);
    }

    public static <R extends ControllerEvent> CompletableFuture<Void> writeBack(R request, EventProcessor.Writer<R> writer) {
        if (writer == null) {
            return CompletableFuture.completedFuture(null);
        }
        return writer.write(request);
    }
}

