/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.eventProcessor.RequestHandler;
import io.pravega.shared.controller.event.ControllerEvent;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SerializedRequestHandler<T extends ControllerEvent>
implements RequestHandler<T> {
    protected final ScheduledExecutorService executor;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<String, ConcurrentLinkedQueue<Work>> workers = new HashMap<String, ConcurrentLinkedQueue<Work>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompletableFuture<Void> process(T streamEvent) {
        ConcurrentLinkedQueue<Work> queue;
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Work work = new Work(this, streamEvent, System.currentTimeMillis(), result);
        String key = streamEvent.getKey();
        Object object = this.lock;
        synchronized (object) {
            if (this.workers.containsKey(key)) {
                this.workers.get(key).add(work);
                queue = null;
            } else {
                queue = new ConcurrentLinkedQueue<Work>();
                queue.add(work);
                this.workers.put(key, queue);
            }
        }
        if (queue != null) {
            this.executor.execute(() -> this.run(key, queue));
        }
        return result;
    }

    public abstract CompletableFuture<Void> processEvent(T var1);

    public boolean toPostpone(T event, long pickupTime, Throwable exception) {
        return false;
    }

    private void run(String key, ConcurrentLinkedQueue<Work> workQueue) {
        CompletableFuture future;
        Work work = workQueue.poll();
        try {
            future = this.processEvent(work.getEvent());
        }
        catch (Exception e2) {
            future = Futures.failedFuture((Throwable)e2);
        }
        future.whenComplete((r, e) -> {
            if (e != null && this.toPostpone(work.getEvent(), work.getPickupTime(), (Throwable)e)) {
                this.handleWorkPostpone(key, workQueue, work);
            } else {
                if (e != null) {
                    work.getResult().completeExceptionally((Throwable)e);
                } else {
                    work.getResult().complete((Void)r);
                }
                this.handleWorkComplete(key, workQueue, work);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWorkPostpone(String key, ConcurrentLinkedQueue<Work> workQueue, Work work) {
        Object object = this.lock;
        synchronized (object) {
            this.workers.get(key).add(work);
        }
        this.executor.execute(() -> this.run(key, workQueue));
    }

    private void handleWorkComplete(String key, ConcurrentLinkedQueue<Work> workQueue, Work work) {
        work.getResult().whenComplete((rw, ew) -> {
            boolean toExecute = false;
            Object object = this.lock;
            synchronized (object) {
                if (workQueue.isEmpty()) {
                    this.workers.remove(key);
                } else {
                    toExecute = true;
                }
            }
            if (toExecute) {
                this.executor.execute(() -> this.run(key, workQueue));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<Pair<T, CompletableFuture<Void>>> getEventQueueForKey(String key) {
        List retVal = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.workers.containsKey(key)) {
                retVal = this.workers.get(key).stream().map(x -> new ImmutablePair(x.getEvent(), x.getResult())).collect(Collectors.toList());
            }
        }
        return retVal;
    }

    @ConstructorProperties(value={"executor"})
    @SuppressFBWarnings(justification="generated code")
    public SerializedRequestHandler(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    private class Work {
        private final T event;
        private final long pickupTime;
        private final CompletableFuture<Void> result;
        final /* synthetic */ SerializedRequestHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        @ConstructorProperties(value={"event", "pickupTime", "result"})
        @SuppressFBWarnings(justification="generated code")
        public Work(T t, long result, CompletableFuture<Void> completableFuture) {
            void var3_3;
            void event;
            this.this$0 = (SerializedRequestHandler)l;
            this.event = event;
            this.pickupTime = var3_3;
            this.result = (CompletableFuture<Void>)result;
        }

        @SuppressFBWarnings(justification="generated code")
        public T getEvent() {
            return this.event;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getPickupTime() {
            return this.pickupTime;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompletableFuture<Void> getResult() {
            return this.result;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Work)) {
                return false;
            }
            Work other = (Work)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$event = this.getEvent();
            Object other$event = other.getEvent();
            if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
                return false;
            }
            if (this.getPickupTime() != other.getPickupTime()) {
                return false;
            }
            CompletableFuture<Void> this$result = this.getResult();
            CompletableFuture<Void> other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof Work;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            long $pickupTime = this.getPickupTime();
            result = result * 59 + (int)($pickupTime >>> 32 ^ $pickupTime);
            CompletableFuture<Void> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "SerializedRequestHandler.Work(event=" + this.getEvent() + ", pickupTime=" + this.getPickupTime() + ", result=" + this.getResult() + ")";
        }
    }
}

