/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.fault;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.cluster.Host;
import io.pravega.controller.fault.ContainerBalancer;
import io.pravega.controller.util.Config;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformContainerBalancer
implements ContainerBalancer {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(UniformContainerBalancer.class);

    @Override
    public Map<Host, Set<Integer>> rebalance(Map<Host, Set<Integer>> prevSegContainerMap, Set<Host> currentHosts) {
        Preconditions.checkNotNull(prevSegContainerMap, (Object)"prevSegContainerMap");
        Preconditions.checkNotNull(currentHosts, (Object)"currentHosts");
        if (currentHosts.isEmpty()) {
            log.info("No hosts found during rebalancing, creating empty map");
            return new HashMap<Host, Set<Integer>>();
        }
        if (prevSegContainerMap.keySet().equals(currentHosts)) {
            log.debug("No change in host list, using existing map");
            return new HashMap<Host, Set<Integer>>(prevSegContainerMap);
        }
        if (prevSegContainerMap.size() == 0 || currentHosts.size() == 1) {
            log.info("Creating new balanced map");
            return this.initializeMap(currentHosts);
        }
        Set<Host> hostsAdded = currentHosts.stream().filter(h -> !prevSegContainerMap.containsKey(h)).collect(Collectors.toSet());
        if (!hostsAdded.isEmpty()) {
            log.debug("New hosts added: {}", hostsAdded);
        }
        Set orphanedContainers = prevSegContainerMap.entrySet().stream().filter(h -> !currentHosts.contains(h.getKey())).flatMap(p -> ((Set)p.getValue()).stream()).collect(Collectors.toSet());
        TreeSet<Map.Entry> mapElements = new TreeSet<Map.Entry>((o1, o2) -> {
            if (((Set)o1.getValue()).size() < ((Set)o2.getValue()).size()) {
                return -1;
            }
            if (((Set)o1.getValue()).size() > ((Set)o2.getValue()).size()) {
                return 1;
            }
            return ((Host)o1.getKey()).hashCode() - ((Host)o2.getKey()).hashCode();
        });
        prevSegContainerMap.entrySet().stream().filter(h -> currentHosts.contains(h.getKey())).forEach(mapElements::add);
        hostsAdded.forEach(h -> mapElements.add(new AbstractMap.SimpleEntry((Host)h, new HashSet())));
        for (Integer container : orphanedContainers) {
            Map.Entry first = (Map.Entry)mapElements.pollFirst();
            ((Set)first.getValue()).add(container);
            mapElements.add(first);
        }
        while (((Set)((Map.Entry)mapElements.last()).getValue()).size() - ((Set)((Map.Entry)mapElements.first()).getValue()).size() > 1) {
            Map.Entry first = (Map.Entry)mapElements.pollFirst();
            Map.Entry last = (Map.Entry)mapElements.pollLast();
            Integer removeCont = (Integer)((Set)last.getValue()).iterator().next();
            ((Set)last.getValue()).remove(removeCont);
            ((Set)first.getValue()).add(removeCont);
            mapElements.add(first);
            mapElements.add(last);
        }
        HashMap<Host, Set<Integer>> newMap = new HashMap<Host, Set<Integer>>();
        mapElements.forEach(m -> {
            Set cfr_ignored_0 = (Set)newMap.put((Host)m.getKey(), (Set<Integer>)m.getValue());
        });
        log.info("Completed segment container rebalancing using new hosts set");
        return newMap;
    }

    private Map<Host, Set<Integer>> initializeMap(Set<Host> currentHosts) {
        int containerCount = Config.HOST_STORE_CONTAINER_COUNT;
        PrimitiveIterator.OfInt intIter = IntStream.range(0, currentHosts.size()).iterator();
        Map<Host, Set<Integer>> segContainerMap = currentHosts.stream().collect(Collectors.toMap(Function.identity(), host -> Stream.of(intIter.next()).flatMap(i -> IntStream.rangeClosed(0, containerCount / currentHosts.size()).boxed().map(j -> j * currentHosts.size() + i)).filter(k -> k < containerCount).collect(Collectors.toSet())));
        return segContainerMap;
    }
}

