/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.metrics;

import io.pravega.common.cluster.Host;
import io.pravega.controller.metrics.AbstractControllerMetrics;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class HostContainerMetrics
extends AbstractControllerMetrics {
    public void updateHostContainerMetrics(Map<Host, Set<Integer>> oldMapping, Map<Host, Set<Integer>> newMapping) {
        if (newMapping == null) {
            return;
        }
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.hosts.count", (Number)newMapping.keySet().size(), new String[0]);
        newMapping.keySet().forEach(host -> this.reportContainerCountPerHost((Host)host, (Set)newMapping.get(host)));
        if (oldMapping == null) {
            return;
        }
        HashSet<Host> workingNodes = new HashSet<Host>(oldMapping.keySet());
        if (workingNodes.retainAll(newMapping.keySet())) {
            oldMapping.keySet().stream().filter(host -> !workingNodes.contains(host)).forEach(failedHost -> {
                this.reportHostFailures((Host)failedHost);
                this.reportContainerFailovers((Set)oldMapping.get(failedHost));
            });
        }
    }

    private void reportContainerCountPerHost(Host host, Set<Integer> containerIds) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.hosts.container_count", (Number)containerIds.size(), MetricsTags.hostTag((String)host.toString()));
    }

    private void reportHostFailures(Host failedHost) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.hosts.failures"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.hosts.failures", 1L, MetricsTags.hostTag((String)failedHost.toString()));
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.hosts.container_count", (Number)0, MetricsTags.hostTag((String)failedHost.toString()));
    }

    private void reportContainerFailovers(Set<Integer> failedContainers) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.container.failovers"), (long)failedContainers.size(), new String[0]);
        for (Integer containerId : failedContainers) {
            DYNAMIC_LOGGER.incCounterValue("pravega.controller.container.failovers", 1L, MetricsTags.containerTag((int)containerId));
        }
    }
}

