/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.metrics;

import io.pravega.controller.metrics.AbstractControllerMetrics;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.OpStatsLogger;
import java.time.Duration;

public final class StreamMetrics
extends AbstractControllerMetrics
implements AutoCloseable {
    private final OpStatsLogger createStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.created_latency_ms", new String[0]);
    private final OpStatsLogger deleteStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.deleted_latency_ms", new String[0]);
    private final OpStatsLogger sealStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.sealed_latency_ms", new String[0]);
    private final OpStatsLogger updateStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.updated_latency_ms", new String[0]);
    private final OpStatsLogger truncateStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.truncated_latency_ms", new String[0]);

    public void createStream(String scope, String streamName, int minNumSegments, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.created", 1L, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.transactions.opened", (Number)0, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segments.count", (Number)minNumSegments, MetricsTags.streamTags((String)scope, (String)streamName));
        this.createStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void createStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.create_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.create_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void deleteStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.deleted", 1L, new String[0]);
        this.deleteStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void deleteStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.delete_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.delete_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void sealStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.sealed", 1L, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.transactions.opened", (Number)0, MetricsTags.streamTags((String)scope, (String)streamName));
        this.sealStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void sealStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.seal_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.seal_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void updateStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.updated"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.updated", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.updateStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void updateStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.update_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.update_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void truncateStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.truncated"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.truncated", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.truncateStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void truncateStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.truncate_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.truncate_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static void reportRetentionEvent(String scope, String streamName) {
        DYNAMIC_LOGGER.recordMeterEvents("pravega.controller.retention.frequency", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static void reportActiveSegments(String scope, String streamName, int numSegments) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segments.count", (Number)numSegments, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static void reportSegmentSplitsAndMerges(String scope, String streamName, long splits, long merges) {
        DYNAMIC_LOGGER.reportGaugeValue(MetricsNames.globalMetricName((String)"pravega.controller.segment.splits"), (Number)splits, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segment.splits", (Number)splits, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.reportGaugeValue(MetricsNames.globalMetricName((String)"pravega.controller.segment.merges"), (Number)merges, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segment.merges", (Number)merges, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    @Override
    public void close() {
        this.createStreamLatency.close();
        this.deleteStreamLatency.close();
        this.sealStreamLatency.close();
        this.updateStreamLatency.close();
        this.truncateStreamLatency.close();
    }
}

