/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.metrics;

import io.pravega.controller.metrics.AbstractControllerMetrics;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.OpStatsLogger;
import java.time.Duration;

public final class TransactionMetrics
extends AbstractControllerMetrics
implements AutoCloseable {
    private final OpStatsLogger createTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.created_latency_ms", new String[0]);
    private final OpStatsLogger commitTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.committed_latency_ms", new String[0]);
    private final OpStatsLogger abortTransactionLatency = STATS_LOGGER.createStats("pravega.controller.transactions.aborted_latency_ms", new String[0]);

    public void createTransaction(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.created"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.created", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.createTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void createTransactionFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.create_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.create_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void commitTransaction(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.committed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.committed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.commitTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void commitTransactionFailed(String scope, String streamName, String txnId) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.commit_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.commit_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.commit_failed", 1L, MetricsTags.transactionTags((String)scope, (String)streamName, (String)txnId));
    }

    public void abortTransaction(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.aborted"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.aborted", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.abortTransactionLatency.reportSuccessValue(latency.toMillis());
    }

    public void abortTransactionFailed(String scope, String streamName, String txnId) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.transactions.abort_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.abort_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.abort_failed", 1L, MetricsTags.transactionTags((String)scope, (String)streamName, (String)txnId));
    }

    public static void reportOpenTransactions(String scope, String streamName, int ongoingTransactions) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.transactions.opened", (Number)ongoingTransactions, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    @Override
    public void close() {
        this.createTransactionLatency.close();
        this.commitTransactionLatency.close();
        this.abortTransactionLatency.close();
    }
}

