/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import io.pravega.common.Exceptions;

public final class AuthResourceRepresentation {
    public static String ofScopes() {
        return "/";
    }

    public static String ofScope(String scopeName) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        return scopeName;
    }

    public static String ofStreamsInScope(String scopeName) {
        return Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
    }

    public static String ofStreamInScope(String scopeName, String streamName) {
        Exceptions.checkNotNullOrEmpty((String)streamName, (String)"streamName");
        return String.format("%s/%s", AuthResourceRepresentation.ofStreamsInScope(scopeName), streamName);
    }

    public static String ofReaderGroupsInScope(String scopeName) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        return scopeName;
    }

    public static String ofReaderGroupInScope(String scopeName, String readerGroupName) {
        Exceptions.checkNotNullOrEmpty((String)readerGroupName, (String)"readerGroupName");
        return String.format("%s/%s", AuthResourceRepresentation.ofReaderGroupsInScope(scopeName), readerGroupName);
    }
}

