/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.ModelHelper;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.cluster.Cluster;
import io.pravega.common.cluster.ClusterException;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.metrics.StreamMetrics;
import io.pravega.controller.metrics.TransactionMetrics;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.controller.task.Stream.StreamTransactionMetadataTasks;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerService {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ControllerService.class);
    private final StreamMetadataStore streamStore;
    private final BucketStore bucketStore;
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamTransactionMetadataTasks streamTransactionMetadataTasks;
    private final SegmentHelper segmentHelper;
    private final Executor executor;
    private final Cluster cluster;
    private final StreamMetrics streamMetrics;
    private final TransactionMetrics transactionMetrics;

    public ControllerService(StreamMetadataStore streamStore, BucketStore bucketStore, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, SegmentHelper segmentHelper, Executor executor, Cluster cluster) {
        this.streamStore = streamStore;
        this.bucketStore = bucketStore;
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamTransactionMetadataTasks = streamTransactionMetadataTasks;
        this.segmentHelper = segmentHelper;
        this.executor = executor;
        this.cluster = cluster;
        this.streamMetrics = new StreamMetrics();
        this.transactionMetrics = new TransactionMetrics();
    }

    public CompletableFuture<List<Controller.NodeUri>> getControllerServerList() {
        if (this.cluster == null) {
            return Futures.failedFuture((Throwable)new IllegalStateException("Controller cluster not initialized"));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.cluster.getClusterMembers().stream().map(host -> Controller.NodeUri.newBuilder().setEndpoint(host.getIpAddr()).setPort(host.getPort()).build()).collect(Collectors.toList());
            }
            catch (ClusterException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }, this.executor);
    }

    public CompletableFuture<Controller.CreateStreamStatus> createStream(String scope, String stream, StreamConfiguration streamConfig, long createTimestamp) {
        Preconditions.checkNotNull((Object)streamConfig, (Object)"streamConfig");
        Preconditions.checkArgument((createTimestamp >= 0L ? 1 : 0) != 0);
        Timer timer = new Timer();
        try {
            NameUtils.validateStreamName((String)stream);
        }
        catch (IllegalArgumentException | NullPointerException e2) {
            log.warn("Create stream failed due to invalid stream name {}", (Object)stream);
            return CompletableFuture.completedFuture(Controller.CreateStreamStatus.newBuilder().setStatus(Controller.CreateStreamStatus.Status.INVALID_STREAM_NAME).build());
        }
        return Futures.exceptionallyExpecting(this.streamStore.getState(scope, stream, true, null, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)State.UNKNOWN)).thenCompose(state -> {
            if (state.equals((Object)State.UNKNOWN) || state.equals((Object)State.CREATING)) {
                return this.streamMetadataTasks.createStreamRetryOnLockFailure(scope, stream, streamConfig, createTimestamp, 10).thenApplyAsync(status -> {
                    this.reportCreateStreamMetrics(scope, stream, streamConfig.getScalingPolicy().getMinNumSegments(), (Controller.CreateStreamStatus.Status)status, timer.getElapsed());
                    return Controller.CreateStreamStatus.newBuilder().setStatus(status).build();
                }, this.executor);
            }
            return CompletableFuture.completedFuture(Controller.CreateStreamStatus.newBuilder().setStatus(Controller.CreateStreamStatus.Status.STREAM_EXISTS).build());
        });
    }

    public CompletableFuture<Controller.UpdateStreamStatus> updateStream(String scope, String stream, StreamConfiguration streamConfig) {
        Preconditions.checkNotNull((Object)streamConfig, (Object)"streamConfig");
        Timer timer = new Timer();
        return this.streamMetadataTasks.updateStream(scope, stream, streamConfig, null).thenApplyAsync(status -> {
            this.reportUpdateStreamMetrics(scope, stream, (Controller.UpdateStreamStatus.Status)status, timer.getElapsed());
            return Controller.UpdateStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.UpdateStreamStatus> truncateStream(String scope, String stream, Map<Long, Long> streamCut) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope");
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull(streamCut, (Object)"streamCut");
        Timer timer = new Timer();
        return this.streamMetadataTasks.truncateStream(scope, stream, streamCut, null).thenApplyAsync(status -> {
            this.reportTruncateStreamMetrics(scope, stream, (Controller.UpdateStreamStatus.Status)status, timer.getElapsed());
            return Controller.UpdateStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<StreamConfiguration> getStream(String scopeName, String streamName) {
        return this.streamStore.getConfiguration(scopeName, streamName, null, this.executor);
    }

    public CompletableFuture<Controller.UpdateStreamStatus> sealStream(String scope, String stream) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Timer timer = new Timer();
        return this.streamMetadataTasks.sealStream(scope, stream, null).thenApplyAsync(status -> {
            this.reportSealStreamMetrics(scope, stream, (Controller.UpdateStreamStatus.Status)status, timer.getElapsed());
            return Controller.UpdateStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<Controller.DeleteStreamStatus> deleteStream(String scope, String stream) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Timer timer = new Timer();
        return this.streamMetadataTasks.deleteStream(scope, stream, null).thenApplyAsync(status -> {
            this.reportDeleteStreamMetrics(scope, stream, (Controller.DeleteStreamStatus.Status)status, timer.getElapsed());
            return Controller.DeleteStreamStatus.newBuilder().setStatus(status).build();
        }, this.executor);
    }

    public CompletableFuture<List<Controller.SegmentRange>> getCurrentSegments(String scope, String stream) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return this.streamStore.getActiveSegments(scope, stream, null, this.executor).thenApplyAsync(activeSegments -> this.getSegmentRanges((List<StreamSegmentRecord>)activeSegments, scope, stream), this.executor);
    }

    public CompletableFuture<Map<Controller.SegmentId, Long>> getSegmentsAtHead(String scope, String stream) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return this.streamStore.getSegmentsAtHead(scope, stream, null, this.executor).thenApply(segments -> segments.entrySet().stream().collect(Collectors.toMap(entry -> ModelHelper.createSegmentId((String)scope, (String)stream, (long)((StreamSegmentRecord)entry.getKey()).segmentId()), Map.Entry::getValue)));
    }

    public CompletableFuture<Map<Controller.SegmentRange, List<Long>>> getSegmentsImmediatelyFollowing(Controller.SegmentId segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        OperationContext context = this.streamStore.createContext(segment.getStreamInfo().getScope(), segment.getStreamInfo().getStream());
        return this.streamStore.getSuccessors(segment.getStreamInfo().getScope(), segment.getStreamInfo().getStream(), segment.getSegmentId(), context, this.executor).thenApply(successors -> successors.entrySet().stream().collect(Collectors.toMap(entry -> ModelHelper.createSegmentRange((String)segment.getStreamInfo().getScope(), (String)segment.getStreamInfo().getStream(), (long)((StreamSegmentRecord)entry.getKey()).segmentId(), (double)((StreamSegmentRecord)entry.getKey()).getKeyStart(), (double)((StreamSegmentRecord)entry.getKey()).getKeyEnd()), Map.Entry::getValue)));
    }

    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsBetweenStreamCuts(Controller.StreamCutRange range) {
        Preconditions.checkNotNull((Object)range, (Object)"segment");
        Preconditions.checkArgument((!range.getFromMap().isEmpty() || !range.getToMap().isEmpty() ? 1 : 0) != 0);
        String scope = range.getStreamInfo().getScope();
        String stream = range.getStreamInfo().getStream();
        OperationContext context = this.streamStore.createContext(scope, stream);
        return this.streamStore.getSegmentsBetweenStreamCuts(scope, stream, range.getFromMap(), range.getToMap(), context, this.executor);
    }

    public CompletableFuture<Controller.ScaleResponse> scale(String scope, String stream, List<Long> segmentsToSeal, Map<Double, Double> newKeyRanges, long scaleTimestamp) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull(segmentsToSeal, (Object)"sealedSegments");
        Preconditions.checkNotNull(newKeyRanges, (Object)"newKeyRanges");
        return this.streamMetadataTasks.manualScale(scope, stream, segmentsToSeal, new ArrayList<Map.Entry<Double, Double>>(ModelHelper.encode(newKeyRanges)), scaleTimestamp, null);
    }

    public CompletableFuture<Controller.ScaleStatusResponse> checkScale(String scope, String stream, int epoch) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Exceptions.checkArgument((epoch >= 0 ? 1 : 0) != 0, (String)"epoch", (String)"Epoch cannot be less than 0", (Object[])new Object[0]);
        return this.streamMetadataTasks.checkScale(scope, stream, epoch, null);
    }

    public CompletableFuture<List<ScaleMetadata>> getScaleRecords(String scope, String stream, long from, long to) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return this.streamStore.getScaleMetadata(scope, stream, from, to, null, this.executor);
    }

    public CompletableFuture<Controller.NodeUri> getURI(Controller.SegmentId segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        return CompletableFuture.completedFuture(this.segmentHelper.getSegmentUri(segment.getStreamInfo().getScope(), segment.getStreamInfo().getStream(), segment.getSegmentId()));
    }

    private Controller.SegmentRange convert(String scope, String stream, StreamSegmentRecord segment) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        return ModelHelper.createSegmentRange((String)scope, (String)stream, (long)segment.segmentId(), (double)segment.getKeyStart(), (double)segment.getKeyEnd());
    }

    public CompletableFuture<Boolean> isSegmentValid(String scope, String stream, long segmentId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return this.streamStore.getActiveSegments(scope, stream, null, this.executor).thenApplyAsync(x -> x.stream().anyMatch(z -> z.segmentId() == segmentId), this.executor);
    }

    public CompletableFuture<Boolean> isStreamCutValid(String scope, String stream, Map<Long, Long> streamCut) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return this.streamStore.isStreamCutValid(scope, stream, streamCut, null, this.executor);
    }

    public CompletableFuture<Pair<UUID, List<Controller.SegmentRange>>> createTransaction(String scope, String stream, long lease) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Timer timer = new Timer();
        return ((CompletableFuture)this.streamTransactionMetadataTasks.createTxn(scope, stream, lease, null).thenApply(pair -> {
            VersionedTransactionData data = (VersionedTransactionData)pair.getKey();
            List segments = (List)pair.getValue();
            return new ImmutablePair((Object)data.getId(), this.getSegmentRanges(segments, scope, stream));
        })).handle((result, ex) -> {
            if (ex != null) {
                this.transactionMetrics.createTransactionFailed(scope, stream);
                throw new CompletionException((Throwable)ex);
            }
            this.transactionMetrics.createTransaction(scope, stream, timer.getElapsed());
            return result;
        });
    }

    private List<Controller.SegmentRange> getSegmentRanges(List<StreamSegmentRecord> activeSegments, String scope, String stream) {
        List<Controller.SegmentRange> listOfSegment = activeSegments.stream().map(segment -> this.convert(scope, stream, (StreamSegmentRecord)segment)).collect(Collectors.toList());
        listOfSegment.sort(Comparator.comparingDouble(Controller.SegmentRange::getMinKey));
        return listOfSegment;
    }

    public CompletableFuture<Controller.TxnStatus> commitTransaction(String scope, String stream, Controller.TxnId txnId, String writerId, long timestamp) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        Timer timer = new Timer();
        UUID txId = ModelHelper.encode((Controller.TxnId)txnId);
        return this.streamTransactionMetadataTasks.commitTxn(scope, stream, txId, writerId, timestamp, null).handle((ok, ex) -> {
            if (ex != null) {
                log.warn("Transaction commit failed", ex);
                this.transactionMetrics.commitTransactionFailed(scope, stream, txId.toString());
                return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.FAILURE).build();
            }
            this.transactionMetrics.commitTransaction(scope, stream, timer.getElapsed());
            return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.SUCCESS).build();
        });
    }

    public CompletableFuture<Controller.TxnStatus> abortTransaction(String scope, String stream, Controller.TxnId txnId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        Timer timer = new Timer();
        UUID txId = ModelHelper.encode((Controller.TxnId)txnId);
        return this.streamTransactionMetadataTasks.abortTxn(scope, stream, txId, null, null).handle((ok, ex) -> {
            if (ex != null) {
                log.warn("Transaction abort failed", ex);
                this.transactionMetrics.abortTransactionFailed(scope, stream, txId.toString());
                return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.FAILURE).build();
            }
            this.transactionMetrics.abortTransaction(scope, stream, timer.getElapsed());
            return Controller.TxnStatus.newBuilder().setStatus(Controller.TxnStatus.Status.SUCCESS).build();
        });
    }

    public CompletableFuture<Controller.PingTxnStatus> pingTransaction(String scope, String stream, Controller.TxnId txnId, long lease) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        UUID txId = ModelHelper.encode((Controller.TxnId)txnId);
        return this.streamTransactionMetadataTasks.pingTxn(scope, stream, txId, lease, null);
    }

    public CompletableFuture<Controller.TxnState> checkTransactionStatus(String scope, String stream, Controller.TxnId txnId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        return this.streamStore.transactionStatus(scope, stream, ModelHelper.encode((Controller.TxnId)txnId), null, this.executor).thenApplyAsync(res -> Controller.TxnState.newBuilder().setState(Controller.TxnState.State.valueOf((String)res.name())).build(), this.executor);
    }

    public CompletableFuture<Controller.CreateScopeStatus> createScope(String scope) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        try {
            NameUtils.validateScopeName((String)scope);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("Create scope failed due to invalid scope name {}", (Object)scope);
            return CompletableFuture.completedFuture(Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.INVALID_SCOPE_NAME).build());
        }
        return this.streamStore.createScope(scope);
    }

    public CompletableFuture<Controller.DeleteScopeStatus> deleteScope(String scope) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        return this.streamStore.deleteScope(scope);
    }

    public CompletableFuture<Map<String, StreamConfiguration>> listStreamsInScope(String scope) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        return this.streamStore.listStreamsInScope(scope);
    }

    public CompletableFuture<Pair<List<String>, String>> listStreams(String scope, String token, int limit) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        return this.streamStore.listStream(scope, token, limit, this.executor);
    }

    public CompletableFuture<List<String>> listScopes() {
        return this.streamStore.listScopes();
    }

    public CompletableFuture<String> getScope(String scopeName) {
        Preconditions.checkNotNull((Object)scopeName);
        return this.streamStore.getScopeConfiguration(scopeName);
    }

    private void reportCreateStreamMetrics(String scope, String streamName, int initialSegments, Controller.CreateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.CreateStreamStatus.Status.SUCCESS)) {
            this.streamMetrics.createStream(scope, streamName, initialSegments, latency);
        } else if (status.equals((Object)Controller.CreateStreamStatus.Status.FAILURE)) {
            this.streamMetrics.createStreamFailed(scope, streamName);
        }
    }

    private void reportUpdateStreamMetrics(String scope, String streamName, Controller.UpdateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateStreamStatus.Status.SUCCESS)) {
            this.streamMetrics.updateStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateStreamStatus.Status.FAILURE)) {
            this.streamMetrics.updateStreamFailed(scope, streamName);
        }
    }

    private void reportTruncateStreamMetrics(String scope, String streamName, Controller.UpdateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateStreamStatus.Status.SUCCESS)) {
            this.streamMetrics.truncateStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateStreamStatus.Status.FAILURE)) {
            this.streamMetrics.truncateStreamFailed(scope, streamName);
        }
    }

    private void reportSealStreamMetrics(String scope, String streamName, Controller.UpdateStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.UpdateStreamStatus.Status.SUCCESS)) {
            this.streamMetrics.sealStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.UpdateStreamStatus.Status.FAILURE)) {
            this.streamMetrics.sealStreamFailed(scope, streamName);
        }
    }

    private void reportDeleteStreamMetrics(String scope, String streamName, Controller.DeleteStreamStatus.Status status, Duration latency) {
        if (status.equals((Object)Controller.DeleteStreamStatus.Status.SUCCESS)) {
            this.streamMetrics.deleteStream(scope, streamName, latency);
        } else if (status.equals((Object)Controller.DeleteStreamStatus.Status.FAILURE)) {
            this.streamMetrics.deleteStreamFailed(scope, streamName);
        }
    }

    public CompletableFuture<Controller.TimestampResponse> noteTimestampFromWriter(String scope, String stream, String writerId, long timestamp, Map<Long, Long> streamCut) {
        return ((CompletableFuture)this.bucketStore.addStreamToBucketStore(BucketStore.ServiceType.WatermarkingService, scope, stream, this.executor).thenCompose(v -> this.streamStore.noteWriterMark(scope, stream, writerId, timestamp, streamCut, null, this.executor))).handle((r, e) -> {
            Controller.TimestampResponse.Builder response = Controller.TimestampResponse.newBuilder();
            if (e != null) {
                response.setResult(Controller.TimestampResponse.Status.INTERNAL_ERROR);
            } else {
                switch (r) {
                    case SUCCESS: {
                        response.setResult(Controller.TimestampResponse.Status.SUCCESS);
                        break;
                    }
                    case INVALID_TIME: {
                        response.setResult(Controller.TimestampResponse.Status.INVALID_TIME);
                        break;
                    }
                    case INVALID_POSITION: {
                        response.setResult(Controller.TimestampResponse.Status.INVALID_POSITION);
                        break;
                    }
                    default: {
                        response.setResult(Controller.TimestampResponse.Status.INTERNAL_ERROR);
                    }
                }
            }
            return response.build();
        });
    }

    public CompletableFuture<Controller.RemoveWriterResponse> removeWriter(String scope, String stream, String writer) {
        return this.streamStore.shutdownWriter(scope, stream, writer, null, this.executor).handle((r, e) -> {
            Controller.RemoveWriterResponse.Builder response = Controller.RemoveWriterResponse.newBuilder();
            if (e != null) {
                if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException) {
                    response.setResult(Controller.RemoveWriterResponse.Status.UNKNOWN_WRITER);
                } else {
                    response.setResult(Controller.RemoveWriterResponse.Status.INTERNAL_ERROR);
                }
            } else {
                response.setResult(Controller.RemoveWriterResponse.Status.SUCCESS);
            }
            return response.build();
        });
    }

    @SuppressFBWarnings(justification="generated code")
    public StreamMetadataStore getStreamStore() {
        return this.streamStore;
    }

    @SuppressFBWarnings(justification="generated code")
    public BucketStore getBucketStore() {
        return this.bucketStore;
    }

    @SuppressFBWarnings(justification="generated code")
    public StreamMetadataTasks getStreamMetadataTasks() {
        return this.streamMetadataTasks;
    }

    @SuppressFBWarnings(justification="generated code")
    public StreamTransactionMetadataTasks getStreamTransactionMetadataTasks() {
        return this.streamTransactionMetadataTasks;
    }

    @SuppressFBWarnings(justification="generated code")
    public SegmentHelper getSegmentHelper() {
        return this.segmentHelper;
    }

    @SuppressFBWarnings(justification="generated code")
    public Executor getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    public Cluster getCluster() {
        return this.cluster;
    }

    @SuppressFBWarnings(justification="generated code")
    public StreamMetrics getStreamMetrics() {
        return this.streamMetrics;
    }

    @SuppressFBWarnings(justification="generated code")
    public TransactionMetrics getTransactionMetrics() {
        return this.transactionMetrics;
    }

    @ConstructorProperties(value={"streamStore", "bucketStore", "streamMetadataTasks", "streamTransactionMetadataTasks", "segmentHelper", "executor", "cluster", "streamMetrics", "transactionMetrics"})
    @SuppressFBWarnings(justification="generated code")
    public ControllerService(StreamMetadataStore streamStore, BucketStore bucketStore, StreamMetadataTasks streamMetadataTasks, StreamTransactionMetadataTasks streamTransactionMetadataTasks, SegmentHelper segmentHelper, Executor executor, Cluster cluster, StreamMetrics streamMetrics, TransactionMetrics transactionMetrics) {
        this.streamStore = streamStore;
        this.bucketStore = bucketStore;
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamTransactionMetadataTasks = streamTransactionMetadataTasks;
        this.segmentHelper = segmentHelper;
        this.executor = executor;
        this.cluster = cluster;
        this.streamMetrics = streamMetrics;
        this.transactionMetrics = transactionMetrics;
    }
}

