/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.server.ControllerServiceMain;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessorConfig;
import io.pravega.controller.server.eventProcessor.impl.ControllerEventProcessorConfigImpl;
import io.pravega.controller.server.impl.ControllerServiceConfigImpl;
import io.pravega.controller.server.rest.impl.RESTServerConfigImpl;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import io.pravega.controller.store.client.StoreClientConfig;
import io.pravega.controller.store.client.impl.StoreClientConfigImpl;
import io.pravega.controller.store.client.impl.ZKClientConfigImpl;
import io.pravega.controller.store.host.impl.HostMonitorConfigImpl;
import io.pravega.controller.timeout.TimeoutServiceConfig;
import io.pravega.controller.util.Config;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.StatsProvider;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (StatsProvider statsProvider = null;){
            MetricsProvider.initialize((MetricsConfig)Config.METRICS_CONFIG);
            statsProvider = MetricsProvider.getMetricsProvider();
            statsProvider.start();
            ZKClientConfigImpl zkClientConfig = ZKClientConfigImpl.builder().connectionString(Config.ZK_URL).secureConnectionToZooKeeper(Config.SECURE_ZK).trustStorePath(Config.ZK_TRUSTSTORE_FILE_PATH).trustStorePasswordPath(Config.ZK_TRUSTSTORE_PASSWORD_FILE_PATH).namespace("pravega/" + Config.CLUSTER_NAME).initialSleepInterval(Config.ZK_RETRY_SLEEP_MS).maxRetries(Config.ZK_MAX_RETRIES).sessionTimeoutMs(Config.ZK_SESSION_TIMEOUT_MS).build();
            StoreClientConfig storeClientConfig = Config.USE_PRAVEGA_TABLES ? StoreClientConfigImpl.withPravegaTablesClient(zkClientConfig) : StoreClientConfigImpl.withZKClient(zkClientConfig);
            HostMonitorConfigImpl hostMonitorConfig = HostMonitorConfigImpl.builder().hostMonitorEnabled(Config.HOST_MONITOR_ENABLED).hostMonitorMinRebalanceInterval(Config.CLUSTER_MIN_REBALANCE_INTERVAL).containerCount(Config.HOST_STORE_CONTAINER_COUNT).hostContainerMap(HostMonitorConfigImpl.getHostContainerMap(Config.SERVICE_HOST, Config.SERVICE_PORT, Config.HOST_STORE_CONTAINER_COUNT)).build();
            TimeoutServiceConfig timeoutServiceConfig = TimeoutServiceConfig.builder().maxLeaseValue(Config.MAX_LEASE_VALUE).build();
            ControllerEventProcessorConfig eventProcessorConfig = ControllerEventProcessorConfigImpl.withDefault();
            GRPCServerConfig grpcServerConfig = Config.GRPC_SERVER_CONFIG;
            RESTServerConfigImpl restServerConfig = RESTServerConfigImpl.builder().host(Config.REST_SERVER_IP).port(Config.REST_SERVER_PORT).tlsEnabled(Config.TLS_ENABLED).keyFilePath(Config.REST_KEYSTORE_FILE_PATH).keyFilePasswordPath(Config.REST_KEYSTORE_PASSWORD_FILE_PATH).build();
            ControllerServiceConfigImpl serviceConfig = ControllerServiceConfigImpl.builder().threadPoolSize(Config.ASYNC_TASK_POOL_SIZE).storeClientConfig(storeClientConfig).hostMonitorConfig(hostMonitorConfig).controllerClusterListenerEnabled(true).timeoutServiceConfig(timeoutServiceConfig).eventProcessorConfig(Optional.of(eventProcessorConfig)).grpcServerConfig(Optional.of(grpcServerConfig)).restServerConfig(Optional.of(restServerConfig)).tlsEnabledForSegmentStore(Config.TLS_ENABLED_FOR_SEGMENT_STORE).build();
            Main.setUncaughtExceptionHandler(Main::logUncaughtException);
            ControllerServiceMain controllerServiceMain = new ControllerServiceMain(serviceConfig);
            controllerServiceMain.startAsync();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Main.onShutdown(controllerServiceMain)));
            controllerServiceMain.awaitTerminated();
            log.info("Controller service exited");
            System.exit(0);
        }
    }

    @VisibleForTesting
    static void setUncaughtExceptionHandler(BiConsumer<Thread, Throwable> exceptionConsumer) {
        Thread.setDefaultUncaughtExceptionHandler(exceptionConsumer::accept);
    }

    static void logUncaughtException(Thread t, Throwable e) {
        log.error("Thread {} with stackTrace {} failed with uncaught exception", new Object[]{t.getName(), t.getStackTrace(), e});
    }

    @VisibleForTesting
    static void onShutdown(ControllerServiceMain controllerServiceMain) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        memoryMXBean.setVerbose(true);
        log.info("Shutdown hook memory usage dump: Heap memory usage: {}, non heap memory usage {}", (Object)memoryMXBean.getHeapMemoryUsage(), (Object)memoryMXBean.getNonHeapMemoryUsage());
        log.info("Controller service shutting down");
        try {
            controllerServiceMain.stopAsync();
            controllerServiceMain.awaitTerminated();
        }
        finally {
            if (Config.DUMP_STACK_ON_SHUTDOWN) {
                Thread.getAllStackTraces().forEach((key, value) -> log.info("Shutdown Hook Thread dump: Thread {} stackTrace: {} ", (Object)key.getName(), value));
            }
        }
    }
}

