/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.shared.protocol.netty.WireCommandType;

public class WireCommandFailedException
extends RuntimeException
implements RetryableException {
    private final WireCommandType type;
    private final Reason reason;

    public WireCommandFailedException(Throwable cause, WireCommandType type, Reason reason) {
        super(cause);
        this.type = type;
        this.reason = reason;
    }

    public WireCommandFailedException(WireCommandType type, Reason reason) {
        super(String.format("WireCommandFailed with type %s reason %s", type.toString(), reason.toString()));
        this.type = type;
        this.reason = reason;
    }

    @SuppressFBWarnings(justification="generated code")
    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        ConnectionDropped,
        ConnectionFailed,
        UnknownHost,
        PreconditionFailed,
        AuthFailed,
        SegmentDoesNotExist,
        TableSegmentNotEmpty,
        TableKeyDoesNotExist,
        TableKeyBadVersion;

    }
}

