/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.server.bucket.BucketManager;
import io.pravega.controller.server.bucket.BucketService;
import io.pravega.controller.server.bucket.BucketWork;
import io.pravega.controller.server.bucket.InMemoryBucketManager;
import io.pravega.controller.server.bucket.InMemoryBucketService;
import io.pravega.controller.server.bucket.ZooKeeperBucketManager;
import io.pravega.controller.server.bucket.ZooKeeperBucketService;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.InMemoryBucketStore;
import io.pravega.controller.store.stream.ZookeeperBucketStore;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketServiceFactory {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(BucketServiceFactory.class);
    private final String hostId;
    private final BucketStore bucketStore;
    private final int maxConcurrentExecutions;

    public BucketServiceFactory(@NonNull String hostId, @NonNull BucketStore bucketStore, int maxConcurrentExecutions) {
        if (hostId == null) {
            throw new NullPointerException("hostId is marked @NonNull but is null");
        }
        if (bucketStore == null) {
            throw new NullPointerException("bucketStore is marked @NonNull but is null");
        }
        this.hostId = hostId;
        this.bucketStore = bucketStore;
        this.maxConcurrentExecutions = maxConcurrentExecutions;
    }

    public BucketManager createRetentionService(Duration executionDuration, BucketWork work, ScheduledExecutorService executorService) {
        switch (this.bucketStore.getStoreType()) {
            case Zookeeper: {
                ZookeeperBucketStore zkBucketStore = (ZookeeperBucketStore)this.bucketStore;
                Function<Integer, BucketService> zkSupplier = bucket -> new ZooKeeperBucketService(BucketStore.ServiceType.RetentionService, (int)bucket, zkBucketStore, executorService, this.maxConcurrentExecutions, executionDuration, work);
                return new ZooKeeperBucketManager(this.hostId, zkBucketStore, BucketStore.ServiceType.RetentionService, executorService, zkSupplier);
            }
            case InMemory: {
                InMemoryBucketStore inMemoryBucketStore = (InMemoryBucketStore)this.bucketStore;
                Function<Integer, BucketService> inMemorySupplier = bucket -> new InMemoryBucketService(BucketStore.ServiceType.RetentionService, (int)bucket, inMemoryBucketStore, executorService, this.maxConcurrentExecutions, executionDuration, work);
                return new InMemoryBucketManager(this.hostId, (InMemoryBucketStore)this.bucketStore, BucketStore.ServiceType.RetentionService, executorService, inMemorySupplier);
            }
        }
        throw new IllegalArgumentException(String.format("store type %s not supported", this.bucketStore.getStoreType().name()));
    }

    public BucketManager createWatermarkingService(Duration executionDuration, BucketWork work, ScheduledExecutorService executorService) {
        switch (this.bucketStore.getStoreType()) {
            case Zookeeper: {
                ZookeeperBucketStore zkBucketStore = (ZookeeperBucketStore)this.bucketStore;
                Function<Integer, BucketService> zkSupplier = bucket -> new ZooKeeperBucketService(BucketStore.ServiceType.WatermarkingService, (int)bucket, zkBucketStore, executorService, this.maxConcurrentExecutions, executionDuration, work);
                return new ZooKeeperBucketManager(this.hostId, zkBucketStore, BucketStore.ServiceType.WatermarkingService, executorService, zkSupplier);
            }
            case InMemory: {
                InMemoryBucketStore inMemoryBucketStore = (InMemoryBucketStore)this.bucketStore;
                Function<Integer, BucketService> inMemorySupplier = bucket -> new InMemoryBucketService(BucketStore.ServiceType.WatermarkingService, (int)bucket, inMemoryBucketStore, executorService, this.maxConcurrentExecutions, executionDuration, work);
                return new InMemoryBucketManager(this.hostId, (InMemoryBucketStore)this.bucketStore, BucketStore.ServiceType.WatermarkingService, executorService, inMemorySupplier);
            }
        }
        throw new IllegalArgumentException(String.format("store type %s not supported", this.bucketStore.getStoreType().name()));
    }
}

