/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.bucket;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.server.bucket.BucketManager;
import io.pravega.controller.server.bucket.BucketService;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.InMemoryBucketStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryBucketManager
extends BucketManager {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(InMemoryBucketManager.class);
    private final BucketStore bucketStore;

    InMemoryBucketManager(String processId, InMemoryBucketStore bucketStore, BucketStore.ServiceType serviceType, ScheduledExecutorService executor, Function<Integer, BucketService> bucketServiceSupplier) {
        super(processId, serviceType, executor, bucketServiceSupplier);
        this.bucketStore = bucketStore;
    }

    @Override
    protected int getBucketCount() {
        return this.bucketStore.getBucketCount(this.getServiceType());
    }

    @Override
    void startBucketOwnershipListener() {
    }

    @Override
    void stopBucketOwnershipListener() {
    }

    @Override
    CompletableFuture<Void> initializeService() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    CompletableFuture<Void> initializeBucket(int bucket) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    CompletableFuture<Boolean> takeBucketOwnership(int bucket, String processId, Executor executor) {
        Preconditions.checkArgument((bucket < this.getBucketCount() ? 1 : 0) != 0);
        return CompletableFuture.completedFuture(true);
    }
}

