/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor;

import com.google.common.base.Preconditions;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.PingFailedException;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.impl.CancellableRequest;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.ControllerFailureException;
import io.pravega.client.stream.impl.ModelHelper;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.client.stream.impl.StreamSegmentSuccessors;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.client.stream.impl.StreamSegmentsWithPredecessors;
import io.pravega.client.stream.impl.TxnSegments;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.ContinuationTokenAsyncIterator;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.rpc.auth.GrpcAuthHelper;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LocalController
implements Controller {
    private static final int LIST_STREAM_IN_SCOPE_LIMIT = 1000;
    private ControllerService controller;
    private final String tokenSigningKey;
    private final boolean authorizationEnabled;

    public LocalController(ControllerService controller, boolean authorizationEnabled, String tokenSigningKey) {
        this.controller = controller;
        this.tokenSigningKey = tokenSigningKey;
        this.authorizationEnabled = authorizationEnabled;
    }

    public CompletableFuture<Boolean> createScope(String scopeName) {
        return this.controller.createScope(scopeName).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to create scope: " + scopeName);
                }
                case INVALID_SCOPE_NAME: {
                    throw new IllegalArgumentException("Illegal scope name: " + scopeName);
                }
                case SCOPE_EXISTS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status creating scope " + scopeName + " " + x.getStatus());
        });
    }

    public AsyncIterator<Stream> listStreams(String scopeName) {
        Function<String, CompletableFuture> function = token -> this.controller.listStreams(scopeName, (String)token, 1000).thenApply(result -> {
            List asStreamList = ((List)result.getKey()).stream().map(m -> new StreamImpl(scopeName, m)).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry(result.getValue(), asStreamList);
        });
        return new ContinuationTokenAsyncIterator(function, (Object)"");
    }

    public CompletableFuture<Boolean> deleteScope(String scopeName) {
        return this.controller.deleteScope(scopeName).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to delete scope: " + scopeName);
                }
                case SCOPE_NOT_EMPTY: {
                    throw new IllegalStateException("Scope " + scopeName + " is not empty.");
                }
                case SCOPE_NOT_FOUND: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status deleting scope " + scopeName + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> createStream(String scope, String streamName, StreamConfiguration streamConfig) {
        return this.controller.createStream(scope, streamName, streamConfig, System.currentTimeMillis()).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to createing stream: " + streamConfig);
                }
                case INVALID_STREAM_NAME: {
                    throw new IllegalArgumentException("Illegal stream name: " + streamConfig);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + streamConfig);
                }
                case STREAM_EXISTS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status creating stream " + streamConfig + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> updateStream(String scope, String streamName, StreamConfiguration streamConfig) {
        return this.controller.updateStream(scope, streamName, streamConfig).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to update stream: " + streamConfig);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + streamConfig);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + streamConfig);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status updating stream " + streamConfig + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> truncateStream(String scope, String stream, StreamCut streamCut) {
        Map<Long, Long> segmentToOffsetMap = streamCut.asImpl().getPositions().entrySet().stream().collect(Collectors.toMap(e -> ((Segment)e.getKey()).getSegmentId(), Map.Entry::getValue));
        return this.truncateStream(scope, stream, segmentToOffsetMap);
    }

    public CompletableFuture<Boolean> truncateStream(String scope, String stream, Map<Long, Long> streamCut) {
        return this.controller.truncateStream(scope, stream, streamCut).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to truncate stream: " + stream);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scope);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + stream);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status truncating stream " + stream + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> sealStream(String scope, String streamName) {
        return this.controller.sealStream(scope, streamName).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to seal stream: " + streamName);
                }
                case SCOPE_NOT_FOUND: {
                    throw new IllegalArgumentException("Scope does not exist: " + scope);
                }
                case STREAM_NOT_FOUND: {
                    throw new IllegalArgumentException("Stream does not exist: " + streamName);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status scealing stream " + streamName + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> deleteStream(String scope, String streamName) {
        return this.controller.deleteStream(scope, streamName).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to delete stream: " + streamName);
                }
                case STREAM_NOT_FOUND: {
                    return false;
                }
                case STREAM_NOT_SEALED: {
                    throw new IllegalArgumentException("Stream is not sealed: " + streamName);
                }
                case SUCCESS: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status deleting stream " + streamName + " " + x.getStatus());
        });
    }

    public CancellableRequest<Boolean> scaleStream(Stream stream, List<Long> sealedSegments, Map<Double, Double> newKeyRanges, ScheduledExecutorService executor) {
        CancellableRequest cancellableRequest = new CancellableRequest();
        this.startScaleInternal(stream, sealedSegments, newKeyRanges).whenComplete((startScaleResponse, e) -> {
            if (e != null) {
                cancellableRequest.start(() -> Futures.failedFuture((Throwable)e), any -> true, executor);
            } else {
                boolean started = startScaleResponse.getStatus().equals((Object)Controller.ScaleResponse.ScaleStreamStatus.STARTED);
                cancellableRequest.start(() -> {
                    if (started) {
                        return this.checkScaleStatus(stream, startScaleResponse.getEpoch());
                    }
                    return CompletableFuture.completedFuture(false);
                }, isDone -> !started || isDone != false, executor);
            }
        });
        return cancellableRequest;
    }

    public CompletableFuture<Boolean> startScale(Stream stream, List<Long> sealedSegments, Map<Double, Double> newKeyRanges) {
        return this.startScaleInternal(stream, sealedSegments, newKeyRanges).thenApply(x -> {
            switch (x.getStatus()) {
                case FAILURE: {
                    throw new ControllerFailureException("Failed to scale stream: " + stream);
                }
                case PRECONDITION_FAILED: {
                    return false;
                }
                case STARTED: {
                    return true;
                }
            }
            throw new ControllerFailureException("Unknown return status scaling stream " + stream + " " + x.getStatus());
        });
    }

    public CompletableFuture<Boolean> checkScaleStatus(Stream stream, int epoch) {
        return this.controller.checkScale(stream.getScope(), stream.getStreamName(), epoch).thenApply(response -> {
            switch (response.getStatus()) {
                case IN_PROGRESS: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
                case INVALID_INPUT: {
                    throw new ControllerFailureException("invalid input");
                }
            }
            throw new ControllerFailureException("unknown error");
        });
    }

    private CompletableFuture<Controller.ScaleResponse> startScaleInternal(Stream stream, List<Long> sealedSegments, Map<Double, Double> newKeyRanges) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull(sealedSegments, (Object)"sealedSegments");
        Preconditions.checkNotNull(newKeyRanges, (Object)"newKeyRanges");
        return this.controller.scale(stream.getScope(), stream.getStreamName(), sealedSegments, newKeyRanges, System.currentTimeMillis());
    }

    public CompletableFuture<StreamSegments> getCurrentSegments(String scope, String streamName) {
        return this.controller.getCurrentSegments(scope, streamName).thenApply(this::getStreamSegments);
    }

    private StreamSegments getStreamSegments(List<Controller.SegmentRange> ranges) {
        TreeMap<Double, SegmentWithRange> rangeMap = new TreeMap<Double, SegmentWithRange>();
        for (Controller.SegmentRange r : ranges) {
            rangeMap.put(r.getMaxKey(), new SegmentWithRange(ModelHelper.encode((Controller.SegmentId)r.getSegmentId()), r.getMinKey(), r.getMaxKey()));
        }
        return new StreamSegments(rangeMap, this.retrieveDelegationToken());
    }

    public CompletableFuture<TxnSegments> createTransaction(Stream stream, long lease) {
        return this.controller.createTransaction(stream.getScope(), stream.getStreamName(), lease).thenApply(pair -> new TxnSegments(this.getStreamSegments((List)pair.getRight()), (UUID)pair.getKey()));
    }

    public CompletableFuture<Transaction.PingStatus> pingTransaction(Stream stream, UUID txId, long lease) {
        return this.controller.pingTransaction(stream.getScope(), stream.getStreamName(), ModelHelper.decode((UUID)txId), lease).thenApply(status -> {
            try {
                return ModelHelper.encode((Controller.PingTxnStatus.Status)status.getStatus(), (String)(stream + " " + txId));
            }
            catch (PingFailedException ex) {
                throw new CompletionException(ex);
            }
        });
    }

    public CompletableFuture<Void> commitTransaction(Stream stream, String writerId, Long timestamp, UUID txnId) {
        long time = Optional.ofNullable(timestamp).orElse(Long.MIN_VALUE);
        return this.controller.commitTransaction(stream.getScope(), stream.getStreamName(), ModelHelper.decode((UUID)txnId), writerId, time).thenApply(x -> null);
    }

    public CompletableFuture<Void> abortTransaction(Stream stream, UUID txId) {
        return this.controller.abortTransaction(stream.getScope(), stream.getStreamName(), ModelHelper.decode((UUID)txId)).thenApply(x -> null);
    }

    public CompletableFuture<Transaction.Status> checkTransactionStatus(Stream stream, UUID txnId) {
        return this.controller.checkTransactionStatus(stream.getScope(), stream.getStreamName(), ModelHelper.decode((UUID)txnId)).thenApply(status -> ModelHelper.encode((Controller.TxnState.State)status.getState(), (String)(stream + " " + txnId)));
    }

    public CompletableFuture<Map<Segment, Long>> getSegmentsAtTime(Stream stream, long timestamp) {
        return this.controller.getSegmentsAtHead(stream.getScope(), stream.getStreamName()).thenApply(segments -> segments.entrySet().stream().collect(Collectors.toMap(entry -> ModelHelper.encode((Controller.SegmentId)((Controller.SegmentId)entry.getKey())), entry -> (Long)entry.getValue())));
    }

    public CompletableFuture<StreamSegmentsWithPredecessors> getSuccessors(Segment segment) {
        return this.controller.getSegmentsImmediatelyFollowing(ModelHelper.decode((Segment)segment)).thenApply(x -> {
            HashMap map = new HashMap();
            x.forEach((segmentId, list) -> map.put(ModelHelper.encode((Controller.SegmentRange)segmentId), list));
            return new StreamSegmentsWithPredecessors(map, this.retrieveDelegationToken());
        });
    }

    public CompletableFuture<StreamSegmentSuccessors> getSuccessors(StreamCut from) {
        return this.getSegments(from, StreamCut.UNBOUNDED);
    }

    public CompletableFuture<StreamSegmentSuccessors> getSegments(StreamCut fromStreamCut, StreamCut toStreamCut) {
        Stream stream = fromStreamCut.asImpl().getStream();
        return ((CompletableFuture)this.controller.getSegmentsBetweenStreamCuts(ModelHelper.decode((String)stream.getScope(), (String)stream.getStreamName(), this.getStreamCutMap(fromStreamCut), this.getStreamCutMap(toStreamCut))).thenApply(segments -> ModelHelper.createStreamCutRangeResponse((String)stream.getScope(), (String)stream.getStreamName(), segments.stream().map(x -> ModelHelper.createSegmentId((String)stream.getScope(), (String)stream.getStreamName(), (long)x.segmentId())).collect(Collectors.toList()), (String)this.retrieveDelegationToken()))).thenApply(response -> new StreamSegmentSuccessors(response.getSegmentsList().stream().map(ModelHelper::encode).collect(Collectors.toSet()), response.getDelegationToken()));
    }

    public CompletableFuture<PravegaNodeUri> getEndpointForSegment(String qualifiedSegmentName) {
        Segment segment = Segment.fromScopedName((String)qualifiedSegmentName);
        return this.controller.getURI(ModelHelper.createSegmentId((String)segment.getScope(), (String)segment.getStreamName(), (long)segment.getSegmentId())).thenApply(ModelHelper::encode);
    }

    public CompletableFuture<Boolean> isSegmentOpen(Segment segment) {
        return this.controller.isSegmentValid(segment.getScope(), segment.getStreamName(), segment.getSegmentId());
    }

    public void close() {
    }

    public String retrieveDelegationToken() {
        if (this.authorizationEnabled) {
            return GrpcAuthHelper.retrieveMasterToken(this.tokenSigningKey);
        }
        return "";
    }

    public CompletableFuture<String> getOrRefreshDelegationTokenFor(String scope, String streamName) {
        String retVal = "";
        if (this.authorizationEnabled) {
            retVal = GrpcAuthHelper.retrieveMasterToken(this.tokenSigningKey);
        }
        return CompletableFuture.completedFuture(retVal);
    }

    private Map<Long, Long> getStreamCutMap(StreamCut streamCut) {
        if (streamCut.equals(StreamCut.UNBOUNDED)) {
            return Collections.emptyMap();
        }
        return streamCut.asImpl().getPositions().entrySet().stream().collect(Collectors.toMap(x -> ((Segment)x.getKey()).getSegmentId(), Map.Entry::getValue));
    }

    public CompletableFuture<Void> noteTimestampFromWriter(String writer, Stream stream, long timestamp, WriterPosition lastWrittenPosition) {
        Map map = ModelHelper.createStreamCut((Stream)stream, (WriterPosition)lastWrittenPosition).getCutMap();
        return Futures.toVoid(this.controller.noteTimestampFromWriter(stream.getScope(), stream.getStreamName(), writer, timestamp, map));
    }

    public CompletableFuture<Void> removeWriter(String writerId, Stream stream) {
        return Futures.toVoid(this.controller.removeWriter(stream.getScope(), stream.getStreamName(), writerId));
    }
}

