/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.common.Exceptions;
import io.pravega.controller.eventProcessor.CheckpointConfig;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessorConfig;
import io.pravega.controller.util.Config;
import io.pravega.shared.NameUtils;

public class ControllerEventProcessorConfigImpl
implements ControllerEventProcessorConfig {
    private final String scopeName;
    private final String commitStreamName;
    private final ScalingPolicy commitStreamScalingPolicy;
    private final String abortStreamName;
    private final ScalingPolicy abortStreamScalingPolicy;
    private final String scaleStreamName;
    private final ScalingPolicy scaleStreamScalingPolicy;
    private final String commitReaderGroupName;
    private final int commitReaderGroupSize;
    private final String abortReaderGroupName;
    private final int abortReaderGroupSize;
    private final String scaleReaderGroupName;
    private final int scaleReaderGroupSize;
    private final CheckpointConfig commitCheckpointConfig;
    private final CheckpointConfig abortCheckpointConfig;
    private final CheckpointConfig scaleCheckpointConfig;

    ControllerEventProcessorConfigImpl(String scopeName, String commitStreamName, ScalingPolicy commitStreamScalingPolicy, String abortStreamName, ScalingPolicy abortStreamScalingPolicy, String commitReaderGroupName, int commitReaderGroupSize, String abortReaderGroupName, int abortReaderGroupSize, CheckpointConfig commitCheckpointConfig, CheckpointConfig abortCheckpointConfig, ScalingPolicy scaleStreamScalingPolicy) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        Exceptions.checkNotNullOrEmpty((String)commitStreamName, (String)"commitStreamName");
        Exceptions.checkNotNullOrEmpty((String)abortStreamName, (String)"abortStreamName");
        Exceptions.checkNotNullOrEmpty((String)commitReaderGroupName, (String)"commitReaderGroupName");
        Exceptions.checkNotNullOrEmpty((String)abortReaderGroupName, (String)"abortReaderGroupName");
        Preconditions.checkArgument((commitReaderGroupSize > 0 ? 1 : 0) != 0, (Object)"commitReaderGroupSize should be a positive integer");
        Preconditions.checkArgument((abortReaderGroupSize > 0 ? 1 : 0) != 0, (Object)"abortReaderGroupSize should be a positive integer");
        Preconditions.checkNotNull((Object)commitStreamScalingPolicy, (Object)"commitStreamScalingPolicy");
        Preconditions.checkNotNull((Object)abortStreamScalingPolicy, (Object)"abortStreamScalingPolicy");
        Preconditions.checkNotNull((Object)scaleStreamScalingPolicy, (Object)"scaleStreamScalingPolicy");
        Preconditions.checkNotNull((Object)commitCheckpointConfig, (Object)"commitCheckpointConfig");
        Preconditions.checkNotNull((Object)abortCheckpointConfig, (Object)"abortCheckpointConfig");
        this.scopeName = scopeName;
        this.commitStreamName = commitStreamName;
        this.commitStreamScalingPolicy = commitStreamScalingPolicy;
        this.abortStreamName = abortStreamName;
        this.abortStreamScalingPolicy = abortStreamScalingPolicy;
        this.commitReaderGroupName = commitReaderGroupName;
        this.commitReaderGroupSize = commitReaderGroupSize;
        this.abortReaderGroupName = abortReaderGroupName;
        this.abortReaderGroupSize = abortReaderGroupSize;
        this.commitCheckpointConfig = commitCheckpointConfig;
        this.abortCheckpointConfig = abortCheckpointConfig;
        this.scaleStreamName = Config.SCALE_STREAM_NAME;
        this.scaleStreamScalingPolicy = scaleStreamScalingPolicy;
        this.scaleReaderGroupName = Config.SCALE_READER_GROUP;
        this.scaleReaderGroupSize = 1;
        this.scaleCheckpointConfig = CheckpointConfig.none();
    }

    public static ControllerEventProcessorConfig withDefault() {
        return ControllerEventProcessorConfigImpl.builder().scopeName("_system").commitStreamName(NameUtils.getInternalNameForStream((String)"commitStream")).abortStreamName(NameUtils.getInternalNameForStream((String)"abortStream")).commitStreamScalingPolicy(ScalingPolicy.fixed((int)2)).abortStreamScalingPolicy(ScalingPolicy.fixed((int)2)).scaleStreamScalingPolicy(ScalingPolicy.fixed((int)2)).commitReaderGroupName("commitStreamReaders").commitReaderGroupSize(1).abortReaderGroupName("abortStreamReaders").abortReaderGroupSize(1).commitCheckpointConfig(CheckpointConfig.periodic(10, 10)).abortCheckpointConfig(CheckpointConfig.periodic(10, 10)).build();
    }

    @Override
    public String getRequestStreamName() {
        return this.scaleStreamName;
    }

    @Override
    public String getRequestReaderGroupName() {
        return this.scaleReaderGroupName;
    }

    @Override
    public ScalingPolicy getRequestStreamScalingPolicy() {
        return this.scaleStreamScalingPolicy;
    }

    @Override
    public CheckpointConfig getRequestStreamCheckpointConfig() {
        return this.scaleCheckpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public static ControllerEventProcessorConfigImplBuilder builder() {
        return new ControllerEventProcessorConfigImplBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ControllerEventProcessorConfigImpl(scopeName=" + this.getScopeName() + ", commitStreamName=" + this.getCommitStreamName() + ", commitStreamScalingPolicy=" + this.getCommitStreamScalingPolicy() + ", abortStreamName=" + this.getAbortStreamName() + ", abortStreamScalingPolicy=" + this.getAbortStreamScalingPolicy() + ", scaleStreamName=" + this.getScaleStreamName() + ", scaleStreamScalingPolicy=" + this.getScaleStreamScalingPolicy() + ", commitReaderGroupName=" + this.getCommitReaderGroupName() + ", commitReaderGroupSize=" + this.getCommitReaderGroupSize() + ", abortReaderGroupName=" + this.getAbortReaderGroupName() + ", abortReaderGroupSize=" + this.getAbortReaderGroupSize() + ", scaleReaderGroupName=" + this.getScaleReaderGroupName() + ", scaleReaderGroupSize=" + this.getScaleReaderGroupSize() + ", commitCheckpointConfig=" + this.getCommitCheckpointConfig() + ", abortCheckpointConfig=" + this.getAbortCheckpointConfig() + ", scaleCheckpointConfig=" + this.getScaleCheckpointConfig() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getCommitStreamName() {
        return this.commitStreamName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public ScalingPolicy getCommitStreamScalingPolicy() {
        return this.commitStreamScalingPolicy;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getAbortStreamName() {
        return this.abortStreamName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public ScalingPolicy getAbortStreamScalingPolicy() {
        return this.abortStreamScalingPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getScaleStreamName() {
        return this.scaleStreamName;
    }

    @SuppressFBWarnings(justification="generated code")
    public ScalingPolicy getScaleStreamScalingPolicy() {
        return this.scaleStreamScalingPolicy;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getCommitReaderGroupName() {
        return this.commitReaderGroupName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getCommitReaderGroupSize() {
        return this.commitReaderGroupSize;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getAbortReaderGroupName() {
        return this.abortReaderGroupName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getAbortReaderGroupSize() {
        return this.abortReaderGroupSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getScaleReaderGroupName() {
        return this.scaleReaderGroupName;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getScaleReaderGroupSize() {
        return this.scaleReaderGroupSize;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public CheckpointConfig getCommitCheckpointConfig() {
        return this.commitCheckpointConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public CheckpointConfig getAbortCheckpointConfig() {
        return this.abortCheckpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public CheckpointConfig getScaleCheckpointConfig() {
        return this.scaleCheckpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ControllerEventProcessorConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String scopeName;
        @SuppressFBWarnings(justification="generated code")
        private String commitStreamName;
        @SuppressFBWarnings(justification="generated code")
        private ScalingPolicy commitStreamScalingPolicy;
        @SuppressFBWarnings(justification="generated code")
        private String abortStreamName;
        @SuppressFBWarnings(justification="generated code")
        private ScalingPolicy abortStreamScalingPolicy;
        @SuppressFBWarnings(justification="generated code")
        private String commitReaderGroupName;
        @SuppressFBWarnings(justification="generated code")
        private int commitReaderGroupSize;
        @SuppressFBWarnings(justification="generated code")
        private String abortReaderGroupName;
        @SuppressFBWarnings(justification="generated code")
        private int abortReaderGroupSize;
        @SuppressFBWarnings(justification="generated code")
        private CheckpointConfig commitCheckpointConfig;
        @SuppressFBWarnings(justification="generated code")
        private CheckpointConfig abortCheckpointConfig;
        @SuppressFBWarnings(justification="generated code")
        private ScalingPolicy scaleStreamScalingPolicy;

        @SuppressFBWarnings(justification="generated code")
        ControllerEventProcessorConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder scopeName(String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder commitStreamName(String commitStreamName) {
            this.commitStreamName = commitStreamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder commitStreamScalingPolicy(ScalingPolicy commitStreamScalingPolicy) {
            this.commitStreamScalingPolicy = commitStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder abortStreamName(String abortStreamName) {
            this.abortStreamName = abortStreamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder abortStreamScalingPolicy(ScalingPolicy abortStreamScalingPolicy) {
            this.abortStreamScalingPolicy = abortStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder commitReaderGroupName(String commitReaderGroupName) {
            this.commitReaderGroupName = commitReaderGroupName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder commitReaderGroupSize(int commitReaderGroupSize) {
            this.commitReaderGroupSize = commitReaderGroupSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder abortReaderGroupName(String abortReaderGroupName) {
            this.abortReaderGroupName = abortReaderGroupName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder abortReaderGroupSize(int abortReaderGroupSize) {
            this.abortReaderGroupSize = abortReaderGroupSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder commitCheckpointConfig(CheckpointConfig commitCheckpointConfig) {
            this.commitCheckpointConfig = commitCheckpointConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder abortCheckpointConfig(CheckpointConfig abortCheckpointConfig) {
            this.abortCheckpointConfig = abortCheckpointConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImplBuilder scaleStreamScalingPolicy(ScalingPolicy scaleStreamScalingPolicy) {
            this.scaleStreamScalingPolicy = scaleStreamScalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerEventProcessorConfigImpl build() {
            return new ControllerEventProcessorConfigImpl(this.scopeName, this.commitStreamName, this.commitStreamScalingPolicy, this.abortStreamName, this.abortStreamScalingPolicy, this.commitReaderGroupName, this.commitReaderGroupSize, this.abortReaderGroupName, this.abortReaderGroupSize, this.commitCheckpointConfig, this.abortCheckpointConfig, this.scaleStreamScalingPolicy);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ControllerEventProcessorConfigImpl.ControllerEventProcessorConfigImplBuilder(scopeName=" + this.scopeName + ", commitStreamName=" + this.commitStreamName + ", commitStreamScalingPolicy=" + this.commitStreamScalingPolicy + ", abortStreamName=" + this.abortStreamName + ", abortStreamScalingPolicy=" + this.abortStreamScalingPolicy + ", commitReaderGroupName=" + this.commitReaderGroupName + ", commitReaderGroupSize=" + this.commitReaderGroupSize + ", abortReaderGroupName=" + this.abortReaderGroupName + ", abortReaderGroupSize=" + this.abortReaderGroupSize + ", commitCheckpointConfig=" + this.commitCheckpointConfig + ", abortCheckpointConfig=" + this.abortCheckpointConfig + ", scaleStreamScalingPolicy=" + this.scaleStreamScalingPolicy + ")";
        }
    }
}

