/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.DeleteStreamEvent;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.LoggerFactory;

public class DeleteStreamTask
implements StreamTask<DeleteStreamEvent> {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(DeleteStreamTask.class));
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamMetadataStore streamMetadataStore;
    private final BucketStore bucketStore;
    private final ScheduledExecutorService executor;

    public DeleteStreamTask(StreamMetadataTasks streamMetadataTasks, StreamMetadataStore streamMetadataStore, BucketStore bucketStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetadataStore);
        Preconditions.checkNotNull((Object)streamMetadataTasks);
        Preconditions.checkNotNull((Object)bucketStore);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamMetadataStore = streamMetadataStore;
        this.bucketStore = bucketStore;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(DeleteStreamEvent request) {
        OperationContext context = this.streamMetadataStore.createContext(request.getScope(), request.getStream());
        String scope = request.getScope();
        String stream = request.getStream();
        long requestId = request.getRequestId();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.streamMetadataStore.getCreationTime(scope, stream, context, this.executor).thenAccept(creationTime -> Preconditions.checkArgument((request.getCreationTime() == 0L || request.getCreationTime() == creationTime.longValue() ? 1 : 0) != 0))).thenCompose(v -> this.streamMetadataStore.getState(scope, stream, true, context, this.executor))).thenComposeAsync(state -> {
            if (!state.equals((Object)State.CREATING) && !state.equals((Object)State.SEALED)) {
                log.warn(requestId, "{}/{} stream not sealed", new Object[]{scope, stream});
                return Futures.failedFuture((Throwable)new RuntimeException("Stream not sealed"));
            }
            return this.deleteAssociatedStreams(scope, stream, requestId).thenCompose(v -> this.notifyAndDelete(context, scope, stream, requestId));
        }, (Executor)this.executor)).exceptionally(e -> {
            if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException) {
                return null;
            }
            log.error(requestId, "{}/{} stream delete workflow threw exception.", new Object[]{scope, stream, e});
            throw new CompletionException((Throwable)e);
        });
    }

    private CompletableFuture<Void> deleteAssociatedStreams(String scope, String stream, long requestId) {
        String markStream = NameUtils.getMarkStreamForStream((String)stream);
        OperationContext context = this.streamMetadataStore.createContext(scope, markStream);
        return Futures.exceptionallyExpecting(this.notifyAndDelete(context, scope, markStream, requestId), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null);
    }

    private CompletableFuture<Void> notifyAndDelete(OperationContext context, String scope, String stream, long requestId) {
        log.info(requestId, "{}/{} deleting segments", new Object[]{scope, stream});
        return ((CompletableFuture)Futures.exceptionallyExpecting((CompletableFuture)this.streamMetadataStore.getAllSegmentIds(scope, stream, context, this.executor).thenComposeAsync(allSegments -> this.streamMetadataTasks.notifyDeleteSegments(scope, stream, (Set<Long>)allSegments, this.streamMetadataTasks.retrieveDelegationToken(), requestId)), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null).thenComposeAsync(x -> this.bucketStore.removeStreamFromBucketStore(BucketStore.ServiceType.RetentionService, scope, stream, this.executor), (Executor)this.executor)).thenComposeAsync(x -> this.streamMetadataStore.deleteStream(scope, stream, context, this.executor), (Executor)this.executor);
    }

    @Override
    public CompletableFuture<Void> writeBack(DeleteStreamEvent event) {
        return this.streamMetadataTasks.writeEvent((ControllerEvent)event);
    }

    @Override
    public CompletableFuture<Boolean> hasTaskStarted(DeleteStreamEvent event) {
        return this.streamMetadataStore.getState(event.getScope(), event.getStream(), true, null, this.executor).thenApply(state -> state.equals((Object)State.SEALED));
    }
}

