/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.server.eventProcessor.requesthandlers.AbstractRequestProcessor;
import io.pravega.controller.server.eventProcessor.requesthandlers.AutoScaleTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.DeleteStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.ScaleOperationTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.SealStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.TaskExceptions;
import io.pravega.controller.server.eventProcessor.requesthandlers.TruncateStreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.UpdateStreamTask;
import io.pravega.controller.store.stream.EpochTransitionOperationExceptions;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.shared.controller.event.AutoScaleEvent;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.DeleteStreamEvent;
import io.pravega.shared.controller.event.ScaleOpEvent;
import io.pravega.shared.controller.event.SealStreamEvent;
import io.pravega.shared.controller.event.TruncateStreamEvent;
import io.pravega.shared.controller.event.UpdateStreamEvent;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRequestHandler
extends AbstractRequestProcessor<ControllerEvent> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamRequestHandler.class);
    private final AutoScaleTask autoScaleTask;
    private final ScaleOperationTask scaleOperationTask;
    private final UpdateStreamTask updateStreamTask;
    private final SealStreamTask sealStreamTask;
    private final DeleteStreamTask deleteStreamTask;
    private final TruncateStreamTask truncateStreamTask;

    public StreamRequestHandler(AutoScaleTask autoScaleTask, ScaleOperationTask scaleOperationTask, UpdateStreamTask updateStreamTask, SealStreamTask sealStreamTask, DeleteStreamTask deleteStreamTask, TruncateStreamTask truncateStreamTask, StreamMetadataStore streamMetadataStore, ScheduledExecutorService executor) {
        super(streamMetadataStore, executor);
        this.autoScaleTask = autoScaleTask;
        this.scaleOperationTask = scaleOperationTask;
        this.updateStreamTask = updateStreamTask;
        this.sealStreamTask = sealStreamTask;
        this.deleteStreamTask = deleteStreamTask;
        this.truncateStreamTask = truncateStreamTask;
    }

    @Override
    public boolean toPostpone(ControllerEvent event, long pickupTime, Throwable exception) {
        return Exceptions.unwrap((Throwable)exception) instanceof TaskExceptions.StartException && System.currentTimeMillis() - pickupTime < Duration.ofMinutes(2L).toMillis();
    }

    @Override
    public CompletableFuture<Void> processAutoScaleRequest(AutoScaleEvent autoScaleEvent) {
        return this.autoScaleTask.execute(autoScaleEvent);
    }

    @Override
    public CompletableFuture<Void> processScaleOpRequest(ScaleOpEvent scaleOpEvent) {
        log.info("Processing scale request {} for stream {}/{}", new Object[]{scaleOpEvent.getRequestId(), scaleOpEvent.getScope(), scaleOpEvent.getStream()});
        return this.withCompletion(this.scaleOperationTask, scaleOpEvent, scaleOpEvent.getScope(), scaleOpEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE.or(e -> e instanceof EpochTransitionOperationExceptions.ConflictException)).thenAccept(v -> log.info("Processing scale request {} for stream {}/{} complete", new Object[]{scaleOpEvent.getRequestId(), scaleOpEvent.getScope(), scaleOpEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processUpdateStream(UpdateStreamEvent updateStreamEvent) {
        log.info("Processing update request {} for stream {}/{}", new Object[]{updateStreamEvent.getRequestId(), updateStreamEvent.getScope(), updateStreamEvent.getStream()});
        return this.withCompletion(this.updateStreamTask, updateStreamEvent, updateStreamEvent.getScope(), updateStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info("Processing update request {} for stream {}/{} complete", new Object[]{updateStreamEvent.getRequestId(), updateStreamEvent.getScope(), updateStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processTruncateStream(TruncateStreamEvent truncateStreamEvent) {
        log.info("Processing truncate request {} for stream {}/{}", new Object[]{truncateStreamEvent.getRequestId(), truncateStreamEvent.getScope(), truncateStreamEvent.getStream()});
        return this.withCompletion(this.truncateStreamTask, truncateStreamEvent, truncateStreamEvent.getScope(), truncateStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info("Processing truncate request {} for stream {}/{} complete", new Object[]{truncateStreamEvent.getRequestId(), truncateStreamEvent.getScope(), truncateStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processSealStream(SealStreamEvent sealStreamEvent) {
        log.info("Processing seal request {} for stream {}/{}", new Object[]{sealStreamEvent.getRequestId(), sealStreamEvent.getScope(), sealStreamEvent.getStream()});
        return this.withCompletion(this.sealStreamTask, sealStreamEvent, sealStreamEvent.getScope(), sealStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info("Processing seal request {} for stream {}/{} complete", new Object[]{sealStreamEvent.getRequestId(), sealStreamEvent.getScope(), sealStreamEvent.getStream()}));
    }

    @Override
    public CompletableFuture<Void> processDeleteStream(DeleteStreamEvent deleteStreamEvent) {
        log.info("Processing delete request {} for stream {}/{}", new Object[]{deleteStreamEvent.getRequestId(), deleteStreamEvent.getScope(), deleteStreamEvent.getStream()});
        return this.withCompletion(this.deleteStreamTask, deleteStreamEvent, deleteStreamEvent.getScope(), deleteStreamEvent.getStream(), OPERATION_NOT_ALLOWED_PREDICATE).thenAccept(v -> log.info("Processing delete request {} for stream {}/{} complete", new Object[]{deleteStreamEvent.getRequestId(), deleteStreamEvent.getScope(), deleteStreamEvent.getStream()}));
    }
}

