/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.eventProcessor.requesthandlers;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.server.eventProcessor.requesthandlers.StreamTask;
import io.pravega.controller.server.eventProcessor.requesthandlers.TaskExceptions;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.VersionedMetadata;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.task.Stream.StreamMetadataTasks;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.UpdateStreamEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStreamTask
implements StreamTask<UpdateStreamEvent> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(UpdateStreamTask.class);
    private final StreamMetadataTasks streamMetadataTasks;
    private final StreamMetadataStore streamMetadataStore;
    private final BucketStore bucketStore;
    private final ScheduledExecutorService executor;

    public UpdateStreamTask(StreamMetadataTasks streamMetadataTasks, StreamMetadataStore streamMetadataStore, BucketStore bucketStore, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)streamMetadataStore);
        Preconditions.checkNotNull((Object)streamMetadataTasks);
        Preconditions.checkNotNull((Object)bucketStore);
        Preconditions.checkNotNull((Object)executor);
        this.streamMetadataTasks = streamMetadataTasks;
        this.streamMetadataStore = streamMetadataStore;
        this.bucketStore = bucketStore;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> execute(UpdateStreamEvent request) {
        OperationContext context = this.streamMetadataStore.createContext(request.getScope(), request.getStream());
        String scope = request.getScope();
        String stream = request.getStream();
        long requestId = request.getRequestId();
        return this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenCompose(versionedState -> this.streamMetadataStore.getConfigurationRecord(scope, stream, context, this.executor).thenCompose(versionedMetadata -> {
            if (!((StreamConfigurationRecord)versionedMetadata.getObject()).isUpdating()) {
                if (((State)((Object)((Object)((Object)versionedState.getObject())))).equals((Object)State.UPDATING)) {
                    return Futures.toVoid(this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)versionedState, context, this.executor));
                }
                throw new TaskExceptions.StartException("Update Stream not started yet.");
            }
            return this.processUpdate(scope, stream, (VersionedMetadata<StreamConfigurationRecord>)versionedMetadata, (VersionedMetadata<State>)versionedState, context, requestId);
        }));
    }

    private CompletableFuture<Void> processUpdate(String scope, String stream, VersionedMetadata<StreamConfigurationRecord> record, VersionedMetadata<State> state, OperationContext context, long requestId) {
        StreamConfigurationRecord configProperty = record.getObject();
        return Futures.toVoid((CompletableFuture)this.streamMetadataStore.updateVersionedState(scope, stream, State.UPDATING, state, context, this.executor).thenCompose(updated -> ((CompletableFuture)((CompletableFuture)this.updateStreamForAutoStreamCut(scope, stream, configProperty, (VersionedMetadata<State>)updated).thenCompose(x -> this.notifyPolicyUpdate(context, scope, stream, configProperty.getStreamConfiguration(), requestId))).thenCompose(x -> this.streamMetadataStore.completeUpdateConfiguration(scope, stream, record, context, this.executor))).thenCompose(x -> this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)updated, context, this.executor))));
    }

    private CompletableFuture<Void> updateStreamForAutoStreamCut(String scope, String stream, StreamConfigurationRecord configProperty, VersionedMetadata<State> updated) {
        if (configProperty.getStreamConfiguration().getRetentionPolicy() != null) {
            return this.bucketStore.addStreamToBucketStore(BucketStore.ServiceType.RetentionService, scope, stream, this.executor);
        }
        return this.bucketStore.removeStreamFromBucketStore(BucketStore.ServiceType.RetentionService, scope, stream, this.executor);
    }

    private CompletableFuture<Boolean> notifyPolicyUpdate(OperationContext context, String scope, String stream, StreamConfiguration newConfig, long requestId) {
        return ((CompletableFuture)this.streamMetadataStore.getActiveSegments(scope, stream, context, this.executor).thenCompose(activeSegments -> this.streamMetadataTasks.notifyPolicyUpdates(scope, stream, (List<StreamSegmentRecord>)activeSegments, newConfig.getScalingPolicy(), this.streamMetadataTasks.retrieveDelegationToken(), requestId))).handle((res, ex) -> {
            if (ex == null) {
                return true;
            }
            throw new CompletionException((Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<Void> writeBack(UpdateStreamEvent event) {
        return this.streamMetadataTasks.writeEvent((ControllerEvent)event);
    }

    @Override
    public CompletableFuture<Boolean> hasTaskStarted(UpdateStreamEvent event) {
        return this.streamMetadataStore.getState(event.getScope(), event.getStream(), true, null, this.executor).thenApply(state -> state.equals((Object)State.UPDATING));
    }
}

