/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.server.ControllerServiceConfig;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessorConfig;
import io.pravega.controller.server.rest.RESTServerConfig;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import io.pravega.controller.store.client.StoreClientConfig;
import io.pravega.controller.store.client.StoreType;
import io.pravega.controller.store.host.HostMonitorConfig;
import io.pravega.controller.timeout.TimeoutServiceConfig;
import java.util.Optional;

public class ControllerServiceConfigImpl
implements ControllerServiceConfig {
    private final int threadPoolSize;
    private final StoreClientConfig storeClientConfig;
    private final HostMonitorConfig hostMonitorConfig;
    private final boolean controllerClusterListenerEnabled;
    private final TimeoutServiceConfig timeoutServiceConfig;
    private final String tlsEnabledForSegmentStore;
    private final Optional<ControllerEventProcessorConfig> eventProcessorConfig;
    private final Optional<GRPCServerConfig> gRPCServerConfig;
    private final Optional<RESTServerConfig> restServerConfig;

    ControllerServiceConfigImpl(int threadPoolSize, StoreClientConfig storeClientConfig, HostMonitorConfig hostMonitorConfig, boolean controllerClusterListenerEnabled, String tlsEnabledForSegmentStore, TimeoutServiceConfig timeoutServiceConfig, Optional<ControllerEventProcessorConfig> eventProcessorConfig, Optional<GRPCServerConfig> grpcServerConfig, Optional<RESTServerConfig> restServerConfig) {
        Exceptions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (String)"threadPoolSize", (String)"Should be positive integer", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)storeClientConfig, (Object)"storeClientConfig");
        Preconditions.checkNotNull((Object)hostMonitorConfig, (Object)"hostMonitorConfig");
        Preconditions.checkNotNull((Object)timeoutServiceConfig, (Object)"timeoutServiceConfig");
        Preconditions.checkNotNull((Object)storeClientConfig, (Object)"storeClientConfig");
        Preconditions.checkNotNull((Object)hostMonitorConfig, (Object)"hostMonitorConfig");
        if (controllerClusterListenerEnabled) {
            Preconditions.checkArgument((storeClientConfig.getStoreType() == StoreType.Zookeeper || storeClientConfig.getStoreType() == StoreType.PravegaTable ? 1 : 0) != 0, (Object)"If controllerCluster is enabled, store type should be Zookeeper");
        }
        if (eventProcessorConfig.isPresent()) {
            Preconditions.checkNotNull((Object)eventProcessorConfig.get());
        }
        if (grpcServerConfig.isPresent()) {
            Preconditions.checkNotNull((Object)grpcServerConfig.get());
        }
        if (restServerConfig.isPresent()) {
            Preconditions.checkNotNull((Object)restServerConfig.get());
        }
        this.threadPoolSize = threadPoolSize;
        this.storeClientConfig = storeClientConfig;
        this.hostMonitorConfig = hostMonitorConfig;
        this.controllerClusterListenerEnabled = controllerClusterListenerEnabled;
        this.tlsEnabledForSegmentStore = tlsEnabledForSegmentStore;
        this.timeoutServiceConfig = timeoutServiceConfig;
        this.eventProcessorConfig = eventProcessorConfig;
        this.gRPCServerConfig = grpcServerConfig;
        this.restServerConfig = restServerConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public static ControllerServiceConfigImplBuilder builder() {
        return new ControllerServiceConfigImplBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ControllerServiceConfigImpl(threadPoolSize=" + this.getThreadPoolSize() + ", storeClientConfig=" + this.getStoreClientConfig() + ", hostMonitorConfig=" + this.getHostMonitorConfig() + ", controllerClusterListenerEnabled=" + this.isControllerClusterListenerEnabled() + ", timeoutServiceConfig=" + this.getTimeoutServiceConfig() + ", tlsEnabledForSegmentStore=" + this.getTlsEnabledForSegmentStore() + ", eventProcessorConfig=" + this.getEventProcessorConfig() + ", gRPCServerConfig=" + this.getGRPCServerConfig() + ", restServerConfig=" + this.getRestServerConfig() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public StoreClientConfig getStoreClientConfig() {
        return this.storeClientConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public HostMonitorConfig getHostMonitorConfig() {
        return this.hostMonitorConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isControllerClusterListenerEnabled() {
        return this.controllerClusterListenerEnabled;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public TimeoutServiceConfig getTimeoutServiceConfig() {
        return this.timeoutServiceConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getTlsEnabledForSegmentStore() {
        return this.tlsEnabledForSegmentStore;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Optional<ControllerEventProcessorConfig> getEventProcessorConfig() {
        return this.eventProcessorConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Optional<GRPCServerConfig> getGRPCServerConfig() {
        return this.gRPCServerConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Optional<RESTServerConfig> getRestServerConfig() {
        return this.restServerConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ControllerServiceConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        private int threadPoolSize;
        @SuppressFBWarnings(justification="generated code")
        private StoreClientConfig storeClientConfig;
        @SuppressFBWarnings(justification="generated code")
        private HostMonitorConfig hostMonitorConfig;
        @SuppressFBWarnings(justification="generated code")
        private boolean controllerClusterListenerEnabled;
        @SuppressFBWarnings(justification="generated code")
        private String tlsEnabledForSegmentStore;
        @SuppressFBWarnings(justification="generated code")
        private TimeoutServiceConfig timeoutServiceConfig;
        @SuppressFBWarnings(justification="generated code")
        private Optional<ControllerEventProcessorConfig> eventProcessorConfig;
        @SuppressFBWarnings(justification="generated code")
        private Optional<GRPCServerConfig> grpcServerConfig;
        @SuppressFBWarnings(justification="generated code")
        private Optional<RESTServerConfig> restServerConfig;

        @SuppressFBWarnings(justification="generated code")
        ControllerServiceConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder storeClientConfig(StoreClientConfig storeClientConfig) {
            this.storeClientConfig = storeClientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder hostMonitorConfig(HostMonitorConfig hostMonitorConfig) {
            this.hostMonitorConfig = hostMonitorConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder controllerClusterListenerEnabled(boolean controllerClusterListenerEnabled) {
            this.controllerClusterListenerEnabled = controllerClusterListenerEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder tlsEnabledForSegmentStore(String tlsEnabledForSegmentStore) {
            this.tlsEnabledForSegmentStore = tlsEnabledForSegmentStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder timeoutServiceConfig(TimeoutServiceConfig timeoutServiceConfig) {
            this.timeoutServiceConfig = timeoutServiceConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder eventProcessorConfig(Optional<ControllerEventProcessorConfig> eventProcessorConfig) {
            this.eventProcessorConfig = eventProcessorConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder grpcServerConfig(Optional<GRPCServerConfig> grpcServerConfig) {
            this.grpcServerConfig = grpcServerConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImplBuilder restServerConfig(Optional<RESTServerConfig> restServerConfig) {
            this.restServerConfig = restServerConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerServiceConfigImpl build() {
            return new ControllerServiceConfigImpl(this.threadPoolSize, this.storeClientConfig, this.hostMonitorConfig, this.controllerClusterListenerEnabled, this.tlsEnabledForSegmentStore, this.timeoutServiceConfig, this.eventProcessorConfig, this.grpcServerConfig, this.restServerConfig);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ControllerServiceConfigImpl.ControllerServiceConfigImplBuilder(threadPoolSize=" + this.threadPoolSize + ", storeClientConfig=" + this.storeClientConfig + ", hostMonitorConfig=" + this.hostMonitorConfig + ", controllerClusterListenerEnabled=" + this.controllerClusterListenerEnabled + ", tlsEnabledForSegmentStore=" + this.tlsEnabledForSegmentStore + ", timeoutServiceConfig=" + this.timeoutServiceConfig + ", eventProcessorConfig=" + this.eventProcessorConfig + ", grpcServerConfig=" + this.grpcServerConfig + ", restServerConfig=" + this.restServerConfig + ")";
        }
    }
}

