/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest;

import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.controller.server.rest.generated.model.CreateStreamRequest;
import io.pravega.controller.server.rest.generated.model.RetentionConfig;
import io.pravega.controller.server.rest.generated.model.ScalingConfig;
import io.pravega.controller.server.rest.generated.model.StreamProperty;
import io.pravega.controller.server.rest.generated.model.UpdateStreamRequest;
import java.time.Duration;

public class ModelHelper {
    public static final StreamConfiguration getCreateStreamConfig(CreateStreamRequest createStreamRequest) {
        ScalingPolicy scalingPolicy = createStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.FIXED_NUM_SEGMENTS ? ScalingPolicy.fixed((int)createStreamRequest.getScalingPolicy().getMinSegments()) : (createStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.BY_RATE_IN_EVENTS_PER_SEC ? ScalingPolicy.byEventRate((int)createStreamRequest.getScalingPolicy().getTargetRate(), (int)createStreamRequest.getScalingPolicy().getScaleFactor(), (int)createStreamRequest.getScalingPolicy().getMinSegments()) : ScalingPolicy.byDataRate((int)createStreamRequest.getScalingPolicy().getTargetRate(), (int)createStreamRequest.getScalingPolicy().getScaleFactor(), (int)createStreamRequest.getScalingPolicy().getMinSegments()));
        RetentionPolicy retentionPolicy = null;
        if (createStreamRequest.getRetentionPolicy() != null) {
            switch (createStreamRequest.getRetentionPolicy().getType()) {
                case LIMITED_SIZE_MB: {
                    retentionPolicy = RetentionPolicy.bySizeBytes((long)(createStreamRequest.getRetentionPolicy().getValue() * 1024L * 1024L));
                    break;
                }
                case LIMITED_DAYS: {
                    retentionPolicy = RetentionPolicy.byTime((Duration)Duration.ofDays(createStreamRequest.getRetentionPolicy().getValue()));
                }
            }
        }
        return StreamConfiguration.builder().scalingPolicy(scalingPolicy).retentionPolicy(retentionPolicy).build();
    }

    public static final StreamConfiguration getUpdateStreamConfig(UpdateStreamRequest updateStreamRequest) {
        ScalingPolicy scalingPolicy = updateStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.FIXED_NUM_SEGMENTS ? ScalingPolicy.fixed((int)updateStreamRequest.getScalingPolicy().getMinSegments()) : (updateStreamRequest.getScalingPolicy().getType() == ScalingConfig.TypeEnum.BY_RATE_IN_EVENTS_PER_SEC ? ScalingPolicy.byEventRate((int)updateStreamRequest.getScalingPolicy().getTargetRate(), (int)updateStreamRequest.getScalingPolicy().getScaleFactor(), (int)updateStreamRequest.getScalingPolicy().getMinSegments()) : ScalingPolicy.byDataRate((int)updateStreamRequest.getScalingPolicy().getTargetRate(), (int)updateStreamRequest.getScalingPolicy().getScaleFactor(), (int)updateStreamRequest.getScalingPolicy().getMinSegments()));
        RetentionPolicy retentionPolicy = null;
        if (updateStreamRequest.getRetentionPolicy() != null) {
            switch (updateStreamRequest.getRetentionPolicy().getType()) {
                case LIMITED_SIZE_MB: {
                    retentionPolicy = RetentionPolicy.bySizeBytes((long)(updateStreamRequest.getRetentionPolicy().getValue() * 1024L * 1024L));
                    break;
                }
                case LIMITED_DAYS: {
                    retentionPolicy = RetentionPolicy.byTime((Duration)Duration.ofDays(updateStreamRequest.getRetentionPolicy().getValue()));
                }
            }
        }
        return StreamConfiguration.builder().scalingPolicy(scalingPolicy).retentionPolicy(retentionPolicy).build();
    }

    public static final StreamProperty encodeStreamResponse(String scope, String streamName, StreamConfiguration streamConfiguration) {
        ScalingConfig scalingPolicy = new ScalingConfig();
        if (streamConfiguration.getScalingPolicy().getScaleType() == ScalingPolicy.ScaleType.FIXED_NUM_SEGMENTS) {
            scalingPolicy.setType(ScalingConfig.TypeEnum.valueOf(streamConfiguration.getScalingPolicy().getScaleType().name()));
            scalingPolicy.setMinSegments(streamConfiguration.getScalingPolicy().getMinNumSegments());
        } else {
            scalingPolicy.setType(ScalingConfig.TypeEnum.valueOf(streamConfiguration.getScalingPolicy().getScaleType().name()));
            scalingPolicy.setTargetRate(streamConfiguration.getScalingPolicy().getTargetRate());
            scalingPolicy.setScaleFactor(streamConfiguration.getScalingPolicy().getScaleFactor());
            scalingPolicy.setMinSegments(streamConfiguration.getScalingPolicy().getMinNumSegments());
        }
        RetentionConfig retentionConfig = null;
        if (streamConfiguration.getRetentionPolicy() != null) {
            retentionConfig = new RetentionConfig();
            switch (streamConfiguration.getRetentionPolicy().getRetentionType()) {
                case SIZE: {
                    retentionConfig.setType(RetentionConfig.TypeEnum.LIMITED_SIZE_MB);
                    retentionConfig.setValue(streamConfiguration.getRetentionPolicy().getRetentionParam() / 0x100000L);
                    break;
                }
                case TIME: {
                    retentionConfig.setType(RetentionConfig.TypeEnum.LIMITED_DAYS);
                    retentionConfig.setValue(Duration.ofMillis(streamConfiguration.getRetentionPolicy().getRetentionParam()).toDays());
                }
            }
        }
        StreamProperty streamProperty = new StreamProperty();
        streamProperty.setScopeName(scope);
        streamProperty.setStreamName(streamName);
        streamProperty.setScalingPolicy(scalingPolicy);
        streamProperty.setRetentionPolicy(retentionConfig);
        return streamProperty;
    }
}

