/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest;

import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.auth.JKSHelper;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.eventProcessor.LocalController;
import io.pravega.controller.server.rest.ControllerApplication;
import io.pravega.controller.server.rest.CustomObjectMapperProvider;
import io.pravega.controller.server.rest.RESTServerConfig;
import io.pravega.controller.server.rest.resources.PingImpl;
import io.pravega.controller.server.rest.resources.StreamMetadataResourceImpl;
import io.pravega.controller.server.rpc.auth.AuthHandlerManager;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServer
extends AbstractIdleService {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(RESTServer.class);
    private static final long MAX_PASSWORD_LENGTH = 0x400000L;
    private final String objectId;
    private final RESTServerConfig restServerConfig;
    private final URI baseUri;
    private final ResourceConfig resourceConfig;
    private HttpServer httpServer;

    public RESTServer(LocalController localController, ControllerService controllerService, AuthHandlerManager pravegaAuthManager, RESTServerConfig restServerConfig, ConnectionFactory connectionFactory) {
        this.objectId = "RESTServer";
        this.restServerConfig = restServerConfig;
        String serverURI = "http://" + restServerConfig.getHost() + "/";
        this.baseUri = UriBuilder.fromUri((String)serverURI).port(restServerConfig.getPort()).build(new Object[0]);
        HashSet<Object> resourceObjs = new HashSet<Object>();
        resourceObjs.add(new PingImpl());
        resourceObjs.add(new StreamMetadataResourceImpl(localController, controllerService, pravegaAuthManager, connectionFactory));
        ControllerApplication controllerApplication = new ControllerApplication(resourceObjs);
        this.resourceConfig = ResourceConfig.forApplication((Application)controllerApplication);
        this.resourceConfig.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        this.resourceConfig.register((Object)new CustomObjectMapperProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startUp", (Object[])new Object[0]);
        try {
            log.info("Starting REST server listening on port: {}", (Object)this.restServerConfig.getPort());
            if (this.restServerConfig.isTlsEnabled()) {
                SSLContextConfigurator contextConfigurator = new SSLContextConfigurator();
                contextConfigurator.setKeyStoreFile(this.restServerConfig.getKeyFilePath());
                contextConfigurator.setKeyStorePass(JKSHelper.loadPasswordFrom((String)this.restServerConfig.getKeyFilePasswordPath()));
                this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)this.resourceConfig, (boolean)true, (SSLEngineConfigurator)new SSLEngineConfigurator(contextConfigurator, false, false, false));
            } else {
                this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)this.resourceConfig, (boolean)true);
            }
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"shutDown", (Object[])new Object[0]);
        try {
            log.info("Stopping REST server listening on port: {}", (Object)this.restServerConfig.getPort());
            GrizzlyFuture shutdown = this.httpServer.shutdown(30L, TimeUnit.SECONDS);
            log.info("Awaiting termination of REST server");
            shutdown.get();
            log.info("REST server terminated");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
        }
    }
}

