/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest.impl;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.server.rest.RESTServerConfig;

public class RESTServerConfigImpl
implements RESTServerConfig {
    private final String host;
    private final int port;
    private final boolean tlsEnabled;
    private final String keyFilePath;
    private final String keyFilePasswordPath;

    RESTServerConfigImpl(String host, int port, boolean tlsEnabled, String keyFilePath, String keyFilePasswordPath) {
        Exceptions.checkNotNullOrEmpty((String)host, (String)"host");
        Exceptions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port", (String)"Should be positive integer", (Object[])new Object[0]);
        Exceptions.checkArgument((!tlsEnabled || !Strings.isNullOrEmpty((String)keyFilePath) ? 1 : 0) != 0, (String)"TLS", (String)"KeyFilePath should not be empty when TLS is enabled. ", (Object[])new Object[0]);
        this.host = host;
        this.port = port;
        this.tlsEnabled = tlsEnabled;
        this.keyFilePath = keyFilePath;
        this.keyFilePasswordPath = keyFilePasswordPath;
    }

    public String toString() {
        return String.format("%s(", this.getClass().getSimpleName()) + String.format("host: %s, ", this.host) + String.format("port: %d, ", this.port) + String.format("tlsEnabled: %b, ", this.tlsEnabled) + String.format("keyFilePath is %s, ", Strings.isNullOrEmpty((String)this.keyFilePath) ? "unspecified" : "specified") + String.format("keyFilePasswordPath is %s", Strings.isNullOrEmpty((String)this.keyFilePasswordPath) ? "unspecified" : "specified") + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public static RESTServerConfigImplBuilder builder() {
        return new RESTServerConfigImplBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getHost() {
        return this.host;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getPort() {
        return this.port;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getKeyFilePasswordPath() {
        return this.keyFilePasswordPath;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class RESTServerConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String host;
        @SuppressFBWarnings(justification="generated code")
        private int port;
        @SuppressFBWarnings(justification="generated code")
        private boolean tlsEnabled;
        @SuppressFBWarnings(justification="generated code")
        private String keyFilePath;
        @SuppressFBWarnings(justification="generated code")
        private String keyFilePasswordPath;

        @SuppressFBWarnings(justification="generated code")
        RESTServerConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public RESTServerConfigImplBuilder host(String host) {
            this.host = host;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public RESTServerConfigImplBuilder port(int port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public RESTServerConfigImplBuilder tlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public RESTServerConfigImplBuilder keyFilePath(String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public RESTServerConfigImplBuilder keyFilePasswordPath(String keyFilePasswordPath) {
            this.keyFilePasswordPath = keyFilePasswordPath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public RESTServerConfigImpl build() {
            return new RESTServerConfigImpl(this.host, this.port, this.tlsEnabled, this.keyFilePath, this.keyFilePasswordPath);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "RESTServerConfigImpl.RESTServerConfigImplBuilder(host=" + this.host + ", port=" + this.port + ", tlsEnabled=" + this.tlsEnabled + ", keyFilePath=" + this.keyFilePath + ", keyFilePasswordPath=" + this.keyFilePasswordPath + ")";
        }
    }
}

