/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest.resources;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.client.SynchronizerClientFactory;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.admin.impl.ReaderGroupManagerImpl;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.stream.InvalidStreamException;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.ClientFactoryImpl;
import io.pravega.client.stream.impl.Controller;
import io.pravega.common.LoggerHelpers;
import io.pravega.controller.server.AuthResourceRepresentation;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.eventProcessor.LocalController;
import io.pravega.controller.server.rest.ModelHelper;
import io.pravega.controller.server.rest.generated.model.CreateScopeRequest;
import io.pravega.controller.server.rest.generated.model.CreateStreamRequest;
import io.pravega.controller.server.rest.generated.model.ReaderGroupProperty;
import io.pravega.controller.server.rest.generated.model.ReaderGroupsList;
import io.pravega.controller.server.rest.generated.model.ReaderGroupsListReaderGroups;
import io.pravega.controller.server.rest.generated.model.ScopeProperty;
import io.pravega.controller.server.rest.generated.model.ScopesList;
import io.pravega.controller.server.rest.generated.model.StreamState;
import io.pravega.controller.server.rest.generated.model.StreamsList;
import io.pravega.controller.server.rest.generated.model.UpdateStreamRequest;
import io.pravega.controller.server.rest.v1.ApiV1;
import io.pravega.controller.server.rpc.auth.AuthHandlerManager;
import io.pravega.controller.server.rpc.auth.RESTAuthHelper;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.NameUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMetadataResourceImpl
implements ApiV1.ScopesApi {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamMetadataResourceImpl.class);
    @Context
    HttpHeaders headers;
    private final ControllerService controllerService;
    private final RESTAuthHelper restAuthHelper;
    private final LocalController localController;
    private final ConnectionFactory connectionFactory;

    public StreamMetadataResourceImpl(LocalController localController, ControllerService controllerService, AuthHandlerManager pravegaAuthManager, ConnectionFactory connectionFactory) {
        this.localController = localController;
        this.controllerService = controllerService;
        this.restAuthHelper = new RESTAuthHelper(pravegaAuthManager);
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void createScope(CreateScopeRequest createScopeRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"createScope", (Object[])new Object[0]);
        try {
            NameUtils.validateUserScopeName((String)createScopeRequest.getScopeName());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("Create scope failed due to invalid scope name {}", (Object)createScopeRequest.getScopeName());
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createScope", (long)traceId, (Object[])new Object[0]);
            return;
        }
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofScopes(), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn("Create scope for {} failed due to authentication failure {}.", (Object)createScopeRequest.getScopeName(), (Object)e);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createScope", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.createScope(createScopeRequest.getScopeName()).thenApply(scopeStatus -> {
            if (scopeStatus.getStatus() == Controller.CreateScopeStatus.Status.SUCCESS) {
                log.info("Successfully created new scope: {}", (Object)createScopeRequest.getScopeName());
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new ScopeProperty().scopeName(createScopeRequest.getScopeName())).build();
            }
            if (scopeStatus.getStatus() == Controller.CreateScopeStatus.Status.SCOPE_EXISTS) {
                log.warn("Scope name: {} already exists", (Object)createScopeRequest.getScopeName());
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            log.warn("Failed to create scope: {}", (Object)createScopeRequest.getScopeName());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn("createScope for scope: {} failed, exception: {}", (Object)createScopeRequest.getScopeName(), exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"createScope", (long)traceId, (Object[])new Object[0]));
    }

    private List<String> getAuthorizationHeader() {
        return this.headers.getRequestHeader("Authorization");
    }

    @Override
    public void createStream(String scopeName, CreateStreamRequest createStreamRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"createStream", (Object[])new Object[0]);
        String streamName = createStreamRequest.getStreamName();
        try {
            NameUtils.validateUserStreamName((String)streamName);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("Create stream failed due to invalid stream name {}", (Object)streamName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofStreamsInScope(scopeName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn("Create stream for {} failed due to authentication failure.", (Object)streamName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        StreamConfiguration streamConfiguration = ModelHelper.getCreateStreamConfig(createStreamRequest);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.createStream(scopeName, streamName, streamConfiguration, System.currentTimeMillis()).thenApply(streamStatus -> {
            Response resp = null;
            if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.SUCCESS) {
                log.info("Successfully created stream: {}/{}", (Object)scopeName, (Object)streamName);
                resp = Response.status((Response.Status)Response.Status.CREATED).entity((Object)ModelHelper.encodeStreamResponse(scopeName, streamName, streamConfiguration)).build();
            } else if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.STREAM_EXISTS) {
                log.warn("Stream already exists: {}/{}", (Object)scopeName, (Object)streamName);
                resp = Response.status((Response.Status)Response.Status.CONFLICT).build();
            } else if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.SCOPE_NOT_FOUND) {
                log.warn("Scope not found: {}", (Object)scopeName);
                resp = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            } else if (streamStatus.getStatus() == Controller.CreateStreamStatus.Status.INVALID_STREAM_NAME) {
                log.warn("Invalid stream name: {}", (Object)streamName);
                resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else {
                log.warn("createStream failed for : {}/{}", (Object)scopeName, (Object)streamName);
                resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            return resp;
        })).exceptionally(exception -> {
            log.warn("createStream for {}/{} failed: ", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void deleteScope(String scopeName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"deleteScope", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofScopes(), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn("Delete scope for {} failed due to authentication failure.", (Object)scopeName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"createStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.deleteScope(scopeName).thenApply(scopeStatus -> {
            if (scopeStatus.getStatus() == Controller.DeleteScopeStatus.Status.SUCCESS) {
                log.info("Successfully deleted scope: {}", (Object)scopeName);
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            if (scopeStatus.getStatus() == Controller.DeleteScopeStatus.Status.SCOPE_NOT_FOUND) {
                log.warn("Scope: {} not found", (Object)scopeName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (scopeStatus.getStatus() == Controller.DeleteScopeStatus.Status.SCOPE_NOT_EMPTY) {
                log.warn("Cannot delete scope: {} with non-empty streams", (Object)scopeName);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            log.warn("deleteScope for {} failed", (Object)scopeName);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn("deleteScope for {} failed with exception: {}", (Object)scopeName, exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"deleteScope", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void deleteStream(String scopeName, String streamName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"deleteStream", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn("Delete stream for {} failed due to authentication failure.", (Object)streamName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"deleteStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.deleteStream(scopeName, streamName).thenApply(deleteStreamStatus -> {
            if (deleteStreamStatus.getStatus() == Controller.DeleteStreamStatus.Status.SUCCESS) {
                log.info("Successfully deleted stream: {}", (Object)streamName);
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            if (deleteStreamStatus.getStatus() == Controller.DeleteStreamStatus.Status.STREAM_NOT_FOUND) {
                log.warn("Scope: {}, Stream {} not found", (Object)scopeName, (Object)streamName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (deleteStreamStatus.getStatus() == Controller.DeleteStreamStatus.Status.STREAM_NOT_SEALED) {
                log.warn("Cannot delete unsealed stream: {}", (Object)streamName);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            log.warn("deleteStream for {} failed", (Object)streamName);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn("deleteStream for {} failed with exception: {}", (Object)streamName, exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"deleteStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void getReaderGroup(String scopeName, String readerGroupName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getReaderGroup", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofReaderGroupInScope(scopeName, readerGroupName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("Get reader group for {} failed due to authentication failure.", (Object)(scopeName + "/" + readerGroupName));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getReaderGroup", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ClientFactoryImpl clientFactory = new ClientFactoryImpl(scopeName, (Controller)this.localController);
        ReaderGroupManagerImpl readerGroupManager = new ReaderGroupManagerImpl(scopeName, (Controller)this.localController, (SynchronizerClientFactory)clientFactory, this.connectionFactory);
        ReaderGroupProperty readerGroupProperty = new ReaderGroupProperty();
        readerGroupProperty.setScopeName(scopeName);
        readerGroupProperty.setReaderGroupName(readerGroupName);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> StreamMetadataResourceImpl.lambda$getReaderGroup$12((ReaderGroupManager)readerGroupManager, readerGroupName, readerGroupProperty), this.controllerService.getExecutor()).exceptionally(exception -> {
            log.warn("getReaderGroup for {} failed with exception: ", (Object)readerGroupName, exception);
            if (exception.getCause() instanceof InvalidStreamException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenAccept(arg_0 -> StreamMetadataResourceImpl.lambda$getReaderGroup$14(asyncResponse, (ReaderGroupManager)readerGroupManager, clientFactory, traceId, arg_0));
    }

    @Override
    public void getScope(String scopeName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getScope", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofScope(scopeName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("Get scope for {} failed due to authentication failure.", (Object)scopeName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getScope", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.getScope(scopeName).thenApply(scope -> Response.status((Response.Status)Response.Status.OK).entity((Object)new ScopeProperty().scopeName((String)scope)).build())).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException) {
                log.warn("Scope: {} not found", (Object)scopeName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("getScope for {} failed with exception: {}", (Object)scopeName, exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"getScope", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void getStream(String scopeName, String streamName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getStream", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("Get stream for {} failed due to authentication failure.", (Object)(scopeName + "/" + streamName));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getStream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.getStream(scopeName, streamName).thenApply(streamConfig -> Response.status((Response.Status)Response.Status.OK).entity((Object)ModelHelper.encodeStreamResponse(scopeName, streamName, streamConfig)).build())).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn("Stream: {}/{} not found", (Object)scopeName, (Object)streamName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("getStream for {}/{} failed with exception: {}", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"getStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void listReaderGroups(String scopeName, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"listReaderGroups", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofReaderGroupsInScope(scopeName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("Get reader groups for {} failed due to authentication failure.", (Object)scopeName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"listReaderGroups", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.listStreamsInScope(scopeName).thenApply(streamsList -> {
            ReaderGroupsList readerGroups = new ReaderGroupsList();
            streamsList.forEach((stream, config) -> {
                if (stream.startsWith("_RG")) {
                    ReaderGroupsListReaderGroups readerGroup = new ReaderGroupsListReaderGroups();
                    readerGroup.setReaderGroupName(stream.substring("_RG".length()));
                    readerGroups.addReaderGroupsItem(readerGroup);
                }
            });
            log.info("Successfully fetched readerGroups for scope: {}", (Object)scopeName);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)readerGroups).build();
        })).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn("Scope name: {} not found", (Object)scopeName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("listReaderGroups for {} failed with exception: ", (Object)scopeName, exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"listReaderGroups", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void listScopes(SecurityContext securityContext, AsyncResponse asyncResponse) {
        Principal principal;
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"listScopes", (Object[])new Object[0]);
        List<String> authHeader = this.getAuthorizationHeader();
        try {
            principal = this.restAuthHelper.authenticate(authHeader);
            this.restAuthHelper.authorize(authHeader, AuthResourceRepresentation.ofScopes(), principal, AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("Get scopes failed due to authentication failure.", (Throwable)e);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"listScopes", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.controllerService.listScopes().thenApply(scopesList -> {
            ScopesList scopes = new ScopesList();
            scopesList.forEach(scope -> {
                try {
                    if (this.restAuthHelper.isAuthorized(authHeader, AuthResourceRepresentation.ofScope(scope), principal, AuthHandler.Permissions.READ)) {
                        scopes.addScopesItem(new ScopeProperty().scopeName((String)scope));
                    }
                }
                catch (AuthException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
            return Response.status((Response.Status)Response.Status.OK).entity((Object)scopes).build();
        })).exceptionally(exception -> {
            log.warn("listScopes failed with exception: ", exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(response -> {
            asyncResponse.resume(response);
            LoggerHelpers.traceLeave((Logger)log, (String)"listScopes", (long)traceId, (Object[])new Object[0]);
            return response;
        });
    }

    @Override
    public void listStreams(String scopeName, String showInternalStreams, SecurityContext securityContext, AsyncResponse asyncResponse) {
        Principal principal;
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"listStreams", (Object[])new Object[0]);
        List<String> authHeader = this.getAuthorizationHeader();
        try {
            principal = this.restAuthHelper.authenticate(authHeader);
            this.restAuthHelper.authorize(authHeader, AuthResourceRepresentation.ofStreamsInScope(scopeName), principal, AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("List streams for {} failed due to authentication failure.", (Object)scopeName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"listStreams", (long)traceId, (Object[])new Object[0]);
            return;
        }
        boolean showOnlyInternalStreams = showInternalStreams != null && showInternalStreams.equals("true");
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.listStreamsInScope(scopeName).thenApply(streamsList -> {
            StreamsList streams = new StreamsList();
            streamsList.forEach((stream, config) -> {
                try {
                    if (this.restAuthHelper.isAuthorized(authHeader, AuthResourceRepresentation.ofStreamInScope(scopeName, stream), principal, AuthHandler.Permissions.READ) && !showOnlyInternalStreams ^ stream.startsWith("_")) {
                        streams.addStreamsItem(ModelHelper.encodeStreamResponse(scopeName, stream, config));
                    }
                }
                catch (AuthException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
            log.info("Successfully fetched streams for scope: {}", (Object)scopeName);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)streams).build();
        })).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn("Scope name: {} not found", (Object)scopeName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("listStreams for {} failed with exception: {}", (Object)scopeName, exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"listStreams", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void updateStream(String scopeName, String streamName, UpdateStreamRequest updateStreamRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"updateStream", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn("Update stream for {} failed due to authentication failure.", (Object)(scopeName + "/" + streamName));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"Update stream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        StreamConfiguration streamConfiguration = ModelHelper.getUpdateStreamConfig(updateStreamRequest);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.updateStream(scopeName, streamName, streamConfiguration).thenApply(streamStatus -> {
            if (streamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SUCCESS) {
                log.info("Successfully updated stream config for: {}/{}", (Object)scopeName, (Object)streamName);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ModelHelper.encodeStreamResponse(scopeName, streamName, streamConfiguration)).build();
            }
            if (streamStatus.getStatus() == Controller.UpdateStreamStatus.Status.STREAM_NOT_FOUND || streamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SCOPE_NOT_FOUND) {
                log.warn("Stream: {}/{} not found", (Object)scopeName, (Object)streamName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("updateStream failed for {}/{}", (Object)scopeName, (Object)streamName);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn("updateStream for {}/{} failed with exception: {}", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"updateStream", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void updateStreamState(String scopeName, String streamName, StreamState updateStreamStateRequest, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"updateStreamState", (Object[])new Object[0]);
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ_UPDATE);
        }
        catch (AuthException e) {
            log.warn("Update stream for {} failed due to authentication failure.", (Object)(scopeName + "/" + streamName));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"Update stream", (long)traceId, (Object[])new Object[0]);
            return;
        }
        if (updateStreamStateRequest.getStreamState() != StreamState.StreamStateEnum.SEALED) {
            log.warn("Received invalid stream state: {} from client for stream {}/{}", new Object[]{updateStreamStateRequest.getStreamState(), scopeName, streamName});
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.sealStream(scopeName, streamName).thenApply(updateStreamStatus -> {
            if (updateStreamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SUCCESS) {
                log.info("Successfully sealed stream: {}", (Object)streamName);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)updateStreamStateRequest).build();
            }
            if (updateStreamStatus.getStatus() == Controller.UpdateStreamStatus.Status.SCOPE_NOT_FOUND || updateStreamStatus.getStatus() == Controller.UpdateStreamStatus.Status.STREAM_NOT_FOUND) {
                log.warn("Scope: {} or Stream {} not found", (Object)scopeName, (Object)streamName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("updateStreamState for {} failed", (Object)streamName);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).exceptionally(exception -> {
            log.warn("updateStreamState for {} failed with exception: {}", (Object)streamName, exception);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"updateStreamState", (long)traceId, (Object[])new Object[0]));
    }

    @Override
    public void getScalingEvents(String scopeName, String streamName, Long from, Long to, SecurityContext securityContext, AsyncResponse asyncResponse) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getScalingEvents", (Object[])new Object[0]);
        if (from == null || to == null) {
            log.warn("Received an invalid request with missing query parameters for scopeName/streamName: {}/{}", (Object)scopeName, (Object)streamName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getScalingEvents", (long)traceId, (Object[])new Object[0]);
            return;
        }
        try {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), AuthResourceRepresentation.ofStreamInScope(scopeName, streamName), AuthHandler.Permissions.READ);
        }
        catch (AuthException e) {
            log.warn("Get scaling events for {} failed due to authentication failure.", (Object)(scopeName + "/" + streamName));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"Get scaling events", (long)traceId, (Object[])new Object[0]);
            return;
        }
        if (from < 0L || to < 0L || from > to) {
            log.warn("Received invalid request from client for scopeName/streamName: {}/{} ", (Object)scopeName, (Object)streamName);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            LoggerHelpers.traceLeave((Logger)log, (String)"getScalingEvents", (long)traceId, (Object[])new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.controllerService.getScaleRecords(scopeName, streamName, from, to).thenApply(listScaleMetadata -> {
            Iterator metadataIterator = listScaleMetadata.iterator();
            ArrayList<ScaleMetadata> finalScaleMetadataList = new ArrayList<ScaleMetadata>();
            ScaleMetadata referenceEvent = null;
            while (metadataIterator.hasNext()) {
                ScaleMetadata scaleMetadata = (ScaleMetadata)metadataIterator.next();
                if (scaleMetadata.getTimestamp() >= from && scaleMetadata.getTimestamp() <= to) {
                    finalScaleMetadataList.add(scaleMetadata);
                    continue;
                }
                if (scaleMetadata.getTimestamp() >= from || referenceEvent != null && referenceEvent.getTimestamp() > scaleMetadata.getTimestamp()) continue;
                referenceEvent = scaleMetadata;
            }
            if (referenceEvent != null) {
                finalScaleMetadataList.add(0, referenceEvent);
            }
            log.info("Successfully fetched required scaling events for scope: {}, stream: {}", (Object)scopeName, (Object)streamName);
            return Response.status((Response.Status)Response.Status.OK).entity(finalScaleMetadataList).build();
        })).exceptionally(exception -> {
            if (exception.getCause() instanceof StoreException.DataNotFoundException || exception instanceof StoreException.DataNotFoundException) {
                log.warn("Stream/Scope name: {}/{} not found", (Object)scopeName, (Object)streamName);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            log.warn("getScalingEvents for scopeName/streamName: {}/{} failed with exception ", new Object[]{scopeName, streamName, exception});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        })).thenApply(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).thenAccept(x -> LoggerHelpers.traceLeave((Logger)log, (String)"getScalingEvents", (long)traceId, (Object[])new Object[0]));
    }

    private static /* synthetic */ void lambda$getReaderGroup$14(AsyncResponse asyncResponse, ReaderGroupManager readerGroupManager, ClientFactoryImpl clientFactory, long traceId, Response response) {
        asyncResponse.resume((Object)response);
        readerGroupManager.close();
        clientFactory.close();
        LoggerHelpers.traceLeave((Logger)log, (String)"getReaderGroup", (long)traceId, (Object[])new Object[0]);
    }

    private static /* synthetic */ Response lambda$getReaderGroup$12(ReaderGroupManager readerGroupManager, String readerGroupName, ReaderGroupProperty readerGroupProperty) {
        ReaderGroup readerGroup = readerGroupManager.getReaderGroup(readerGroupName);
        readerGroupProperty.setOnlineReaderIds(new ArrayList<String>(readerGroup.getOnlineReaders()));
        readerGroupProperty.setStreamList(new ArrayList<String>(readerGroup.getStreamNames()));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)readerGroupProperty).build();
    }
}

