/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rest.v1;

import io.pravega.controller.server.rest.generated.model.CreateScopeRequest;
import io.pravega.controller.server.rest.generated.model.CreateStreamRequest;
import io.pravega.controller.server.rest.generated.model.ReaderGroupProperty;
import io.pravega.controller.server.rest.generated.model.ReaderGroupsList;
import io.pravega.controller.server.rest.generated.model.ScalingEventList;
import io.pravega.controller.server.rest.generated.model.ScopeProperty;
import io.pravega.controller.server.rest.generated.model.ScopesList;
import io.pravega.controller.server.rest.generated.model.StreamProperty;
import io.pravega.controller.server.rest.generated.model.StreamState;
import io.pravega.controller.server.rest.generated.model.StreamsList;
import io.pravega.controller.server.rest.generated.model.UpdateStreamRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public final class ApiV1 {

    @Path(value="/v1/scopes")
    @Api(description="the scopes API")
    public static interface ScopesApi {
        @POST
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Creates a new scope", response=ScopeProperty.class, tags={})
        @ApiResponses(value={@ApiResponse(code=201, message="Successfully created the scope", response=ScopeProperty.class), @ApiResponse(code=409, message="Scope already exists", response=ScopeProperty.class), @ApiResponse(code=500, message="Server error", response=ScopeProperty.class)})
        public void createScope(@ApiParam(value="The scope configuration", required=true) CreateScopeRequest var1, @Context SecurityContext var2, @Suspended AsyncResponse var3);

        @POST
        @Path(value="/{scopeName}/streams")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Creates a new stream", response=StreamProperty.class, tags={})
        @ApiResponses(value={@ApiResponse(code=201, message="Successful created the stream", response=StreamProperty.class), @ApiResponse(code=404, message="Scope not found", response=StreamProperty.class), @ApiResponse(code=409, message="Stream already exists", response=StreamProperty.class), @ApiResponse(code=500, message="Server error", response=StreamProperty.class)})
        public void createStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="The stream configuration", required=true) CreateStreamRequest var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @DELETE
        @Path(value="/{scopeName}")
        @ApiOperation(value="", notes="Delete a scope", response=void.class, tags={})
        @ApiResponses(value={@ApiResponse(code=204, message="Successfully deleted the scope", response=void.class), @ApiResponse(code=404, message="Scope not found", response=void.class), @ApiResponse(code=412, message="Cannot delete scope which has non-empty list of streams", response=void.class), @ApiResponse(code=500, message="Server error", response=void.class)})
        public void deleteScope(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3);

        @DELETE
        @Path(value="/{scopeName}/streams/{streamName}")
        @ApiOperation(value="", notes="Delete a stream", response=void.class, tags={})
        @ApiResponses(value={@ApiResponse(code=204, message="Successfully deleted the stream", response=void.class), @ApiResponse(code=404, message="Stream not found", response=void.class), @ApiResponse(code=412, message="Cannot delete stream since it is not sealed", response=void.class), @ApiResponse(code=500, message="Server error", response=void.class)})
        public void deleteStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{scopeName}/readergroups/{readerGroupName}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the properties of an existing reader group", response=ReaderGroupProperty.class, tags={"ReaderGroups"})
        @ApiResponses(value={@ApiResponse(code=200, message="Found reader group properties", response=ReaderGroupProperty.class), @ApiResponse(code=404, message="Scope or reader group with given name not found", response=ReaderGroupProperty.class), @ApiResponse(code=500, message="Internal server error while fetching reader group details", response=ReaderGroupProperty.class)})
        public void getReaderGroup(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Reader group name", required=true) @PathParam(value="readerGroupName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{scopeName}/streams/{streamName}/scaling-events")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Get scaling events for a given datetime period.", response=ScalingEventList.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="List of scaling events", response=ScalingEventList.class), @ApiResponse(code=404, message="Scope/Stream not found", response=ScalingEventList.class), @ApiResponse(code=500, message="Server error", response=ScalingEventList.class)})
        public void getScalingEvents(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String var2, @ApiParam(value="Parameter to display scaling events from that particular datetime. Input should be milliseconds from Jan 1 1970.", required=true) @QueryParam(value="from") Long var3, @ApiParam(value="Parameter to display scaling events to that particular datetime. Input should be milliseconds from Jan 1 1970.", required=true) @QueryParam(value="to") Long var4, @Context SecurityContext var5, @Suspended AsyncResponse var6);

        @GET
        @Path(value="/{scopeName}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Retrieve scope", response=ScopeProperty.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved the scope", response=ScopeProperty.class), @ApiResponse(code=404, message="Scope not found", response=ScopeProperty.class), @ApiResponse(code=500, message="Server error", response=ScopeProperty.class)})
        public void getScope(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3);

        @GET
        @Path(value="/{scopeName}/streams/{streamName}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the stream properties", response=StreamProperty.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="Found stream configuration", response=StreamProperty.class), @ApiResponse(code=404, message="Scope or stream not found", response=StreamProperty.class), @ApiResponse(code=500, message="Server error", response=StreamProperty.class)})
        public void getStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @GET
        @Path(value="/{scopeName}/readergroups")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="List reader groups within the given scope", response=ReaderGroupsList.class, tags={"ReaderGroups"})
        @ApiResponses(value={@ApiResponse(code=200, message="List of all reader groups configured for the given scope", response=ReaderGroupsList.class), @ApiResponse(code=404, message="Scope not found", response=ReaderGroupsList.class), @ApiResponse(code=500, message="Internal server error while fetching the list of reader groups for the given scope", response=ReaderGroupsList.class)})
        public void listReaderGroups(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3);

        @GET
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="List all scopes in the system", response=ScopesList.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="List of scope objects", response=ScopesList.class), @ApiResponse(code=500, message="Server error", response=ScopesList.class)})
        public void listScopes(@Context SecurityContext var1, @Suspended AsyncResponse var2);

        @GET
        @Path(value="/{scopeName}/streams")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="List streams within the given scope", response=StreamsList.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="List of stream objects", response=StreamsList.class), @ApiResponse(code=404, message="Scope not found", response=StreamsList.class), @ApiResponse(code=500, message="Server error", response=StreamsList.class)})
        public void listStreams(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Flag whether to display only system created streams") @QueryParam(value="showInternalStreams") String var2, @Context SecurityContext var3, @Suspended AsyncResponse var4);

        @PUT
        @Path(value="/{scopeName}/streams/{streamName}")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="", response=StreamProperty.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="Successfully updated the stream configuration", response=StreamProperty.class), @ApiResponse(code=404, message="Scope or stream not found", response=StreamProperty.class), @ApiResponse(code=500, message="Server error", response=StreamProperty.class)})
        public void updateStream(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String var2, @ApiParam(value="The new stream configuration", required=true) UpdateStreamRequest var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);

        @PUT
        @Path(value="/{scopeName}/streams/{streamName}/state")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Updates the current state of the stream", response=StreamState.class, tags={})
        @ApiResponses(value={@ApiResponse(code=200, message="Successfully updated the stream state", response=StreamState.class), @ApiResponse(code=404, message="Scope or stream not found", response=StreamState.class), @ApiResponse(code=500, message="Server error", response=StreamState.class)})
        public void updateStreamState(@ApiParam(value="Scope name", required=true) @PathParam(value="scopeName") String var1, @ApiParam(value="Stream name", required=true) @PathParam(value="streamName") String var2, @ApiParam(value="The state info to be updated", required=true) StreamState var3, @Context SecurityContext var4, @Suspended AsyncResponse var5);
    }

    @Path(value="/ping")
    public static interface Ping {
        @GET
        public Response ping();
    }
}

