/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.ServerConfig;
import io.pravega.controller.server.rpc.auth.AuthInterceptor;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHandlerManager {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(AuthHandlerManager.class);
    private final GRPCServerConfig serverConfig;
    @GuardedBy(value="this")
    private final Map<String, AuthHandler> handlerMap;

    public AuthHandlerManager(GRPCServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.handlerMap = new HashMap<String, AuthHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthHandler getHandler(String handlerName) throws AuthenticationException {
        AuthHandler retVal;
        AuthHandlerManager authHandlerManager = this;
        synchronized (authHandlerManager) {
            retVal = this.handlerMap.get(handlerName);
        }
        if (retVal == null) {
            throw new AuthenticationException("Handler does not exist for method " + handlerName);
        }
        return retVal;
    }

    public boolean authenticateAndAuthorize(String resource, String credentials, AuthHandler.Permissions level) throws AuthenticationException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        boolean retVal = false;
        try {
            String[] parts = this.extractMethodAndToken(credentials);
            String method = parts[0];
            String token = parts[1];
            AuthHandler handler = this.getHandler(method);
            Preconditions.checkNotNull((Object)handler, (Object)"Can not find handler.");
            Principal principal = handler.authenticate(token);
            if (principal == null) {
                throw new AuthenticationException("Authentication failure");
            }
            retVal = handler.authorize(resource, principal).ordinal() >= level.ordinal();
        }
        catch (AuthException e) {
            throw new AuthenticationException("Authentication failure");
        }
        return retVal;
    }

    public Principal authenticate(String credentials) throws AuthException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        String[] parts = this.extractMethodAndToken(credentials);
        String method = parts[0];
        String token = parts[1];
        AuthHandler handler = this.getHandler(method);
        Preconditions.checkNotNull((Object)handler, (Object)"Can not find handler.");
        return handler.authenticate(token);
    }

    private String[] extractMethodAndToken(String credentials) throws AuthenticationException {
        String[] parts = credentials.split("\\s+", 2);
        if (parts.length != 2) {
            throw new AuthenticationException("Malformed request");
        }
        return parts;
    }

    public boolean authorize(String resource, Principal principal, String credentials, AuthHandler.Permissions level) throws AuthException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        String[] parts = this.extractMethodAndToken(credentials);
        String method = parts[0];
        AuthHandler handler = this.getHandler(method);
        Preconditions.checkNotNull((Object)handler, (Object)"Can not find handler.");
        return handler.authorize(resource, principal).ordinal() >= level.ordinal();
    }

    @VisibleForTesting
    public synchronized void registerHandler(AuthHandler authHandler) {
        Preconditions.checkNotNull((Object)authHandler, (Object)"authHandler");
        this.handlerMap.put(authHandler.getHandlerName(), authHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterceptors(ServerBuilder<?> builder) {
        block9: {
            try {
                if (!this.serverConfig.isAuthorizationEnabled()) break block9;
                ServiceLoader<AuthHandler> loader = ServiceLoader.load(AuthHandler.class);
                for (AuthHandler handler : loader) {
                    try {
                        handler.initialize((ServerConfig)this.serverConfig);
                        AuthHandlerManager authHandlerManager = this;
                        synchronized (authHandlerManager) {
                            if (this.handlerMap.putIfAbsent(handler.getHandlerName(), handler) != null) {
                                log.warn("Handler with name {} already exists. Not replacing it with the latest handler");
                                continue;
                            }
                        }
                        builder.intercept((ServerInterceptor)new AuthInterceptor(handler));
                    }
                    catch (Exception e) {
                        log.warn("Exception while initializing auth handler {}", (Object)handler, (Object)e);
                    }
                }
            }
            catch (Throwable e) {
                log.warn("Exception while loading the auth handlers", e);
            }
        }
    }
}

