/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthInterceptor
implements ServerInterceptor {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private static final String PRINCIPAL_KEY_NAME = "PravegaContext";
    private static final String INTERCEPTOR_KEY_NAME = "InterceptorContext";
    static final Context.Key<Principal> PRINCIPAL_OBJECT_KEY = Context.key((String)"PravegaContext");
    static final Context.Key<AuthInterceptor> AUTH_INTERCEPTOR_OBJECT_KEY = Context.key((String)"InterceptorContext");
    private final AuthHandler handler;

    AuthInterceptor(AuthHandler handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"handler can not be null");
        this.handler = handler;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String[] parts;
        Context context = Context.current();
        String credentials = (String)headers.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        if (!Strings.isNullOrEmpty((String)credentials) && (parts = credentials.split("\\s+", 2)).length == 2) {
            String method = parts[0];
            String token = parts[1];
            if (!Strings.isNullOrEmpty((String)method)) {
                if (method.equals(this.handler.getHandlerName())) {
                    Principal principal;
                    log.debug("Handler [{}] successfully matched auth method [{}]", (Object)this.handler, (Object)method);
                    try {
                        principal = this.handler.authenticate(token);
                        if (principal == null) {
                            log.warn("Handler for method [{}] returned a null Principal upon authentication for thegiven token", (Object)method);
                            call.close(Status.fromCode((Status.Code)Status.Code.UNAUTHENTICATED), headers);
                            return null;
                        }
                    }
                    catch (AuthException e) {
                        log.warn("Authentication failed", (Throwable)e);
                        call.close(Status.fromCode((Status.Code)Status.Code.UNAUTHENTICATED), headers);
                        return null;
                    }
                    context = context.withValues(PRINCIPAL_OBJECT_KEY, (Object)principal, AUTH_INTERCEPTOR_OBJECT_KEY, (Object)this);
                }
            } else {
                log.debug("Credentials are present, but method [{}] is null or empty", (Object)method);
            }
        }
        return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
    }

    @SuppressFBWarnings(justification="generated code")
    public AuthHandler getHandler() {
        return this.handler;
    }
}

