/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.ServerConfig;
import io.pravega.controller.server.rpc.auth.StrongPasswordProcessor;
import io.pravega.controller.server.rpc.auth.UserPrincipal;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthHandler
implements AuthHandler {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(PasswordAuthHandler.class);
    private final ConcurrentHashMap<String, PravegaACls> userMap = new ConcurrentHashMap();
    private final StrongPasswordProcessor encryptor = StrongPasswordProcessor.builder().build();

    private void loadPasswordFile(String userPasswordFile) {
        log.debug("Loading {}", (Object)userPasswordFile);
        try (FileReader reader = new FileReader(userPasswordFile);
             BufferedReader lineReader = new BufferedReader(reader);){
            String line;
            while (!Strings.isNullOrEmpty((String)(line = lineReader.readLine()))) {
                String[] userFields;
                if (line.startsWith("#") || (userFields = line.split(":")).length < 2) continue;
                String acls = userFields.length == 2 ? "" : userFields[2];
                this.userMap.put(userFields[0], new PravegaACls(userFields[1], this.getAcls(acls)));
            }
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    public String getHandlerName() {
        return "Basic";
    }

    public Principal authenticate(String token) throws AuthException {
        String[] parts = PasswordAuthHandler.parseToken(token);
        String userName = parts[0];
        char[] password = parts[1].toCharArray();
        try {
            if (this.userMap.containsKey(userName) && this.encryptor.checkPassword(password, this.userMap.get(userName).encryptedPassword)) {
                UserPrincipal userPrincipal = new UserPrincipal(userName);
                return userPrincipal;
            }
            try {
                throw new AuthenticationException("User authentication exception");
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                log.warn("Exception during password authentication", (Throwable)e);
                throw new AuthenticationException((Exception)e);
            }
        }
        finally {
            Arrays.fill(password, '0');
        }
    }

    public AuthHandler.Permissions authorize(String resource, Principal principal) {
        String userName = principal.getName();
        if (Strings.isNullOrEmpty((String)userName) || !this.userMap.containsKey(userName)) {
            throw new CompletionException((Throwable)new AuthenticationException(userName));
        }
        return this.authorizeForUser(this.userMap.get(userName), resource);
    }

    @VisibleForTesting
    void initialize(String passwordFile) {
        this.loadPasswordFile(passwordFile);
    }

    public void initialize(ServerConfig serverConfig) {
        this.loadPasswordFile(((GRPCServerConfig)serverConfig).getUserPasswordFile());
    }

    private static String[] parseToken(String token) {
        String[] parts = new String(Base64.getDecoder().decode(token), Charsets.UTF_8).split(":", 2);
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)"Invalid authorization token");
        return parts;
    }

    private AuthHandler.Permissions authorizeForUser(PravegaACls pravegaACls, String resource) {
        AuthHandler.Permissions result = AuthHandler.Permissions.NONE;
        for (PravegaAcl acl : pravegaACls.acls) {
            String[] values;
            if (acl.isResource(resource)) {
                result = acl.permissions;
                break;
            }
            if (acl.isResource("/*") && !resource.contains("/")) {
                result = acl.permissions;
                break;
            }
            if (acl.resourceEndsWith("/") && acl.resourceStartsWith(resource)) {
                result = acl.permissions;
                break;
            }
            if (resource.contains("/") && !resource.endsWith("/") && acl.isResource((values = resource.split("/"))[0] + "/*")) {
                result = acl.permissions;
                break;
            }
            if (!acl.isResource("*") || !acl.hasHigherPermissionsThan(result)) continue;
            result = acl.permissions;
            break;
        }
        return result;
    }

    private List<PravegaAcl> getAcls(String aclString) {
        return Arrays.stream(aclString.split(";")).map(acl -> {
            String[] splits = acl.split(",");
            if (splits.length == 0) {
                return null;
            }
            String resource = splits[0];
            String aclVal = "READ";
            if (splits.length >= 2) {
                aclVal = splits[1];
            }
            return new PravegaAcl(resource, AuthHandler.Permissions.valueOf((String)aclVal));
        }).collect(Collectors.toList());
    }

    private class PravegaAcl {
        private final String resourceRepresentation;
        private final AuthHandler.Permissions permissions;

        public boolean isResource(String resource) {
            return this.resourceRepresentation.equals(resource);
        }

        public boolean resourceEndsWith(String resource) {
            return this.resourceRepresentation.endsWith(resource);
        }

        public boolean resourceStartsWith(String resource) {
            return this.resourceRepresentation.startsWith(resource);
        }

        public boolean hasHigherPermissionsThan(AuthHandler.Permissions input) {
            return this.permissions.ordinal() > input.ordinal();
        }

        @ConstructorProperties(value={"resourceRepresentation", "permissions"})
        @SuppressFBWarnings(justification="generated code")
        public PravegaAcl(String resourceRepresentation, AuthHandler.Permissions permissions) {
            this.resourceRepresentation = resourceRepresentation;
            this.permissions = permissions;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getResourceRepresentation() {
            return this.resourceRepresentation;
        }

        @SuppressFBWarnings(justification="generated code")
        public AuthHandler.Permissions getPermissions() {
            return this.permissions;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PravegaAcl)) {
                return false;
            }
            PravegaAcl other = (PravegaAcl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resourceRepresentation = this.getResourceRepresentation();
            String other$resourceRepresentation = other.getResourceRepresentation();
            if (this$resourceRepresentation == null ? other$resourceRepresentation != null : !this$resourceRepresentation.equals(other$resourceRepresentation)) {
                return false;
            }
            AuthHandler.Permissions this$permissions = this.getPermissions();
            AuthHandler.Permissions other$permissions = other.getPermissions();
            return !(this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof PravegaAcl;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resourceRepresentation = this.getResourceRepresentation();
            result = result * 59 + ($resourceRepresentation == null ? 43 : $resourceRepresentation.hashCode());
            AuthHandler.Permissions $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "PasswordAuthHandler.PravegaAcl(resourceRepresentation=" + this.getResourceRepresentation() + ", permissions=" + this.getPermissions() + ")";
        }
    }

    private class PravegaACls {
        private final String encryptedPassword;
        private final List<PravegaAcl> acls;

        @ConstructorProperties(value={"encryptedPassword", "acls"})
        @SuppressFBWarnings(justification="generated code")
        public PravegaACls(String encryptedPassword, List<PravegaAcl> acls) {
            this.encryptedPassword = encryptedPassword;
            this.acls = acls;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getEncryptedPassword() {
            return this.encryptedPassword;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<PravegaAcl> getAcls() {
            return this.acls;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PravegaACls)) {
                return false;
            }
            PravegaACls other = (PravegaACls)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$encryptedPassword = this.getEncryptedPassword();
            String other$encryptedPassword = other.getEncryptedPassword();
            if (this$encryptedPassword == null ? other$encryptedPassword != null : !this$encryptedPassword.equals(other$encryptedPassword)) {
                return false;
            }
            List<PravegaAcl> this$acls = this.getAcls();
            List<PravegaAcl> other$acls = other.getAcls();
            return !(this$acls == null ? other$acls != null : !((Object)this$acls).equals(other$acls));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof PravegaACls;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $encryptedPassword = this.getEncryptedPassword();
            result = result * 59 + ($encryptedPassword == null ? 43 : $encryptedPassword.hashCode());
            List<PravegaAcl> $acls = this.getAcls();
            result = result * 59 + ($acls == null ? 43 : ((Object)$acls).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "PasswordAuthHandler.PravegaACls(encryptedPassword=" + this.getEncryptedPassword() + ", acls=" + this.getAcls() + ")";
        }
    }
}

