/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class StrongPasswordProcessor {
    private String keyAlgorythm;
    private int keyLength;
    private int saltLength;
    private int iterations;

    public boolean checkPassword(char[] password, String encryptedPassword) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String storedPassword = new String(this.fromHex(encryptedPassword));
        String[] parts = storedPassword.split(":");
        int iterations = Integer.parseInt(parts[0]);
        byte[] salt = this.fromHex(parts[1]);
        byte[] hash = this.fromHex(parts[2]);
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, this.keyLength);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.keyAlgorythm);
        byte[] testHash = skf.generateSecret(spec).getEncoded();
        int diff = hash.length ^ testHash.length;
        for (int i = 0; i < hash.length && i < testHash.length; ++i) {
            diff |= hash[i] ^ testHash[i];
        }
        return diff == 0;
    }

    public String encryptPassword(String userPassword) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] chars = userPassword.toCharArray();
        byte[] salt = this.getSalt();
        PBEKeySpec spec = new PBEKeySpec(chars, salt, this.iterations, this.keyLength);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.keyAlgorythm);
        byte[] hash = skf.generateSecret(spec).getEncoded();
        return this.toHex((this.iterations + ":" + this.toHex(salt) + ":" + this.toHex(hash)).getBytes());
    }

    private byte[] getSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[this.saltLength];
        sr.nextBytes(salt);
        return salt;
    }

    private String toHex(byte[] array) throws NoSuchAlgorithmException {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    private byte[] fromHex(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    @SuppressFBWarnings(justification="generated code")
    private static String $default$keyAlgorythm() {
        return "PBKDF2WithHmacSHA256";
    }

    @SuppressFBWarnings(justification="generated code")
    private static int $default$keyLength() {
        return 512;
    }

    @SuppressFBWarnings(justification="generated code")
    private static int $default$saltLength() {
        return 32;
    }

    @SuppressFBWarnings(justification="generated code")
    private static int $default$iterations() {
        return 5000;
    }

    @ConstructorProperties(value={"keyAlgorythm", "keyLength", "saltLength", "iterations"})
    @SuppressFBWarnings(justification="generated code")
    StrongPasswordProcessor(String keyAlgorythm, int keyLength, int saltLength, int iterations) {
        this.keyAlgorythm = keyAlgorythm;
        this.keyLength = keyLength;
        this.saltLength = saltLength;
        this.iterations = iterations;
    }

    @SuppressFBWarnings(justification="generated code")
    public static StrongPasswordProcessorBuilder builder() {
        return new StrongPasswordProcessorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class StrongPasswordProcessorBuilder {
        @SuppressFBWarnings(justification="generated code")
        private boolean keyAlgorythm$set;
        @SuppressFBWarnings(justification="generated code")
        private String keyAlgorythm;
        @SuppressFBWarnings(justification="generated code")
        private boolean keyLength$set;
        @SuppressFBWarnings(justification="generated code")
        private int keyLength;
        @SuppressFBWarnings(justification="generated code")
        private boolean saltLength$set;
        @SuppressFBWarnings(justification="generated code")
        private int saltLength;
        @SuppressFBWarnings(justification="generated code")
        private boolean iterations$set;
        @SuppressFBWarnings(justification="generated code")
        private int iterations;

        @SuppressFBWarnings(justification="generated code")
        StrongPasswordProcessorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StrongPasswordProcessorBuilder keyAlgorythm(String keyAlgorythm) {
            this.keyAlgorythm = keyAlgorythm;
            this.keyAlgorythm$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StrongPasswordProcessorBuilder keyLength(int keyLength) {
            this.keyLength = keyLength;
            this.keyLength$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StrongPasswordProcessorBuilder saltLength(int saltLength) {
            this.saltLength = saltLength;
            this.saltLength$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StrongPasswordProcessorBuilder iterations(int iterations) {
            this.iterations = iterations;
            this.iterations$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StrongPasswordProcessor build() {
            String keyAlgorythm = this.keyAlgorythm;
            if (!this.keyAlgorythm$set) {
                keyAlgorythm = StrongPasswordProcessor.$default$keyAlgorythm();
            }
            int keyLength = this.keyLength;
            if (!this.keyLength$set) {
                keyLength = StrongPasswordProcessor.$default$keyLength();
            }
            int saltLength = this.saltLength;
            if (!this.saltLength$set) {
                saltLength = StrongPasswordProcessor.$default$saltLength();
            }
            int iterations = this.iterations;
            if (!this.iterations$set) {
                iterations = StrongPasswordProcessor.$default$iterations();
            }
            return new StrongPasswordProcessor(keyAlgorythm, keyLength, saltLength, iterations);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StrongPasswordProcessor.StrongPasswordProcessorBuilder(keyAlgorythm=" + this.keyAlgorythm + ", keyLength=" + this.keyLength + ", saltLength=" + this.saltLength + ", iterations=" + this.iterations + ")";
        }
    }
}

