/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.auth;

import io.pravega.auth.AuthHandler;
import io.pravega.auth.ServerConfig;
import io.pravega.controller.server.rpc.auth.UserPrincipal;
import java.security.Principal;

public class TestAuthHandler
implements AuthHandler {
    public static final String DUMMY_USER = "dummy";
    public static final String ADMIN_USER = "admin";

    public String getHandlerName() {
        return "testHandler";
    }

    public Principal authenticate(String token) {
        return new UserPrincipal(token);
    }

    public AuthHandler.Permissions authorize(String resource, Principal principal) {
        if (principal.getName().contains(DUMMY_USER)) {
            return AuthHandler.Permissions.NONE;
        }
        return AuthHandler.Permissions.READ_UPDATE;
    }

    public void initialize(ServerConfig serverConfig) {
    }

    public static String testAuthToken(String userName) {
        return String.format("testHandler %s", userName);
    }
}

