/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.grpc;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.controller.server.ControllerService;
import io.pravega.controller.server.rpc.auth.AuthHandlerManager;
import io.pravega.controller.server.rpc.auth.GrpcAuthHelper;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import io.pravega.controller.server.rpc.grpc.v1.ControllerServiceImpl;
import io.pravega.shared.controller.tracing.RPCTracingHelpers;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCServer
extends AbstractIdleService {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(GRPCServer.class);
    private final String objectId;
    private final Server server;
    private final GRPCServerConfig config;
    private final AuthHandlerManager authHandlerManager;

    public GRPCServer(ControllerService controllerService, GRPCServerConfig serverConfig, RequestTracker requestTracker) {
        this.objectId = "gRPCServer";
        this.config = serverConfig;
        GrpcAuthHelper authHelper = new GrpcAuthHelper(serverConfig.isAuthorizationEnabled(), serverConfig.getTokenSigningKey(), serverConfig.getAccessTokenTTLInSeconds());
        ServerBuilder builder = ServerBuilder.forPort((int)serverConfig.getPort()).addService(ServerInterceptors.intercept((BindableService)new ControllerServiceImpl(controllerService, authHelper, requestTracker, serverConfig.isReplyWithStackTraceOnError()), (ServerInterceptor[])new ServerInterceptor[]{RPCTracingHelpers.getServerInterceptor((RequestTracker)requestTracker)}));
        if (serverConfig.isAuthorizationEnabled()) {
            this.authHandlerManager = new AuthHandlerManager(serverConfig);
            this.authHandlerManager.registerInterceptors(builder);
        } else {
            this.authHandlerManager = null;
        }
        if (serverConfig.isTlsEnabled() && !Strings.isNullOrEmpty((String)serverConfig.getTlsCertFile())) {
            builder = builder.useTransportSecurity(new File(serverConfig.getTlsCertFile()), new File(serverConfig.getTlsKeyFile()));
        }
        this.server = builder.build();
    }

    protected void startUp() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startUp", (Object[])new Object[0]);
        try {
            log.info("Starting gRPC server listening on port: {}", (Object)this.config.getPort());
            this.server.start();
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    protected void shutDown() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"shutDown", (Object[])new Object[0]);
        try {
            log.info("Stopping gRPC server listening on port: {}", (Object)this.config.getPort());
            this.server.shutdown();
            log.info("Awaiting termination of gRPC server");
            this.server.awaitTermination();
            log.info("gRPC server terminated");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public AuthHandlerManager getAuthHandlerManager() {
        return this.authHandlerManager;
    }
}

