/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.server.rpc.grpc.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import java.util.Optional;

public class GRPCServerConfigImpl
implements GRPCServerConfig {
    private final int port;
    private final Optional<String> publishedRPCHost;
    private final Optional<Integer> publishedRPCPort;
    private final boolean authorizationEnabled;
    private final String userPasswordFile;
    private final boolean tlsEnabled;
    private final String tlsCertFile;
    private final String tlsKeyFile;
    private final String tokenSigningKey;
    private final Integer accessTokenTTLInSeconds;
    private final String tlsTrustStore;
    private final boolean replyWithStackTraceOnError;
    private final boolean requestTracingEnabled;

    public GRPCServerConfigImpl(int port, String publishedRPCHost, Integer publishedRPCPort, boolean authorizationEnabled, String userPasswordFile, boolean tlsEnabled, String tlsCertFile, String tlsKeyFile, String tokenSigningKey, Integer accessTokenTTLInSeconds, String tlsTrustStore, boolean replyWithStackTraceOnError, boolean requestTracingEnabled) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Invalid port.");
        if (publishedRPCHost != null) {
            Exceptions.checkNotNullOrEmpty((String)publishedRPCHost, (String)"publishedRPCHost");
        }
        if (publishedRPCPort != null) {
            Preconditions.checkArgument((publishedRPCPort > 0 ? 1 : 0) != 0, (Object)"publishedRPCPort should be a positive integer");
        }
        if (accessTokenTTLInSeconds != null) {
            Preconditions.checkArgument((accessTokenTTLInSeconds == -1 || accessTokenTTLInSeconds >= 0 ? 1 : 0) != 0, (Object)"accessTokenTtlInSeconds should be -1 (token never expires), 0 (token immediately expires) or a positive integer representing the number of seconds after which the token expires.");
        }
        this.port = port;
        this.publishedRPCHost = Optional.ofNullable(publishedRPCHost);
        this.publishedRPCPort = Optional.ofNullable(publishedRPCPort);
        this.authorizationEnabled = authorizationEnabled;
        this.userPasswordFile = userPasswordFile;
        this.tlsEnabled = tlsEnabled;
        this.tlsCertFile = tlsCertFile;
        this.tlsKeyFile = tlsKeyFile;
        this.tlsTrustStore = tlsTrustStore;
        this.tokenSigningKey = tokenSigningKey;
        this.accessTokenTTLInSeconds = accessTokenTTLInSeconds;
        this.replyWithStackTraceOnError = replyWithStackTraceOnError;
        this.requestTracingEnabled = requestTracingEnabled;
    }

    public String toString() {
        return "GRPCServerConfigImpl(" + String.format("port: %d, ", this.port) + String.format("publishedRPCHost: %s, ", this.publishedRPCHost.isPresent() ? this.publishedRPCHost.get() : "null") + String.format("publishedRPCPort: %s, ", this.publishedRPCPort.isPresent() ? this.publishedRPCPort.get() : "null") + String.format("authorizationEnabled: %b, ", this.authorizationEnabled) + String.format("userPasswordFile is %s, ", Strings.isNullOrEmpty((String)this.userPasswordFile) ? "unspecified" : "specified") + String.format("tokenSigningKey is %s, ", Strings.isNullOrEmpty((String)this.tokenSigningKey) ? "unspecified" : "specified") + String.format("accessTokenTTLInSeconds: %s, ", this.accessTokenTTLInSeconds) + String.format("tlsEnabled: %b, ", this.tlsEnabled) + String.format("tlsCertFile is %s, ", Strings.isNullOrEmpty((String)this.tlsCertFile) ? "unspecified" : "specified") + String.format("tlsKeyFile is %s, ", Strings.isNullOrEmpty((String)this.tlsKeyFile) ? "unspecified" : "specified") + String.format("tlsTrustStore is %s, ", Strings.isNullOrEmpty((String)this.tlsTrustStore) ? "unspecified" : "specified") + String.format("replyWithStackTraceOnError: %b, ", this.replyWithStackTraceOnError) + String.format("requestTracingEnabled: %b", this.requestTracingEnabled) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public static GRPCServerConfigImplBuilder builder() {
        return new GRPCServerConfigImplBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getPort() {
        return this.port;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Optional<String> getPublishedRPCHost() {
        return this.publishedRPCHost;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Optional<Integer> getPublishedRPCPort() {
        return this.publishedRPCPort;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getUserPasswordFile() {
        return this.userPasswordFile;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getTlsCertFile() {
        return this.tlsCertFile;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getTlsKeyFile() {
        return this.tlsKeyFile;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getTokenSigningKey() {
        return this.tokenSigningKey;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Integer getAccessTokenTTLInSeconds() {
        return this.accessTokenTTLInSeconds;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isReplyWithStackTraceOnError() {
        return this.replyWithStackTraceOnError;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isRequestTracingEnabled() {
        return this.requestTracingEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GRPCServerConfigImpl)) {
            return false;
        }
        GRPCServerConfigImpl other = (GRPCServerConfigImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        Optional<String> this$publishedRPCHost = this.getPublishedRPCHost();
        Optional<String> other$publishedRPCHost = other.getPublishedRPCHost();
        if (this$publishedRPCHost == null ? other$publishedRPCHost != null : !((Object)this$publishedRPCHost).equals(other$publishedRPCHost)) {
            return false;
        }
        Optional<Integer> this$publishedRPCPort = this.getPublishedRPCPort();
        Optional<Integer> other$publishedRPCPort = other.getPublishedRPCPort();
        if (this$publishedRPCPort == null ? other$publishedRPCPort != null : !((Object)this$publishedRPCPort).equals(other$publishedRPCPort)) {
            return false;
        }
        if (this.isAuthorizationEnabled() != other.isAuthorizationEnabled()) {
            return false;
        }
        String this$userPasswordFile = this.getUserPasswordFile();
        String other$userPasswordFile = other.getUserPasswordFile();
        if (this$userPasswordFile == null ? other$userPasswordFile != null : !this$userPasswordFile.equals(other$userPasswordFile)) {
            return false;
        }
        if (this.isTlsEnabled() != other.isTlsEnabled()) {
            return false;
        }
        String this$tlsCertFile = this.getTlsCertFile();
        String other$tlsCertFile = other.getTlsCertFile();
        if (this$tlsCertFile == null ? other$tlsCertFile != null : !this$tlsCertFile.equals(other$tlsCertFile)) {
            return false;
        }
        String this$tlsKeyFile = this.getTlsKeyFile();
        String other$tlsKeyFile = other.getTlsKeyFile();
        if (this$tlsKeyFile == null ? other$tlsKeyFile != null : !this$tlsKeyFile.equals(other$tlsKeyFile)) {
            return false;
        }
        String this$tokenSigningKey = this.getTokenSigningKey();
        String other$tokenSigningKey = other.getTokenSigningKey();
        if (this$tokenSigningKey == null ? other$tokenSigningKey != null : !this$tokenSigningKey.equals(other$tokenSigningKey)) {
            return false;
        }
        Integer this$accessTokenTTLInSeconds = this.getAccessTokenTTLInSeconds();
        Integer other$accessTokenTTLInSeconds = other.getAccessTokenTTLInSeconds();
        if (this$accessTokenTTLInSeconds == null ? other$accessTokenTTLInSeconds != null : !((Object)this$accessTokenTTLInSeconds).equals(other$accessTokenTTLInSeconds)) {
            return false;
        }
        String this$tlsTrustStore = this.getTlsTrustStore();
        String other$tlsTrustStore = other.getTlsTrustStore();
        if (this$tlsTrustStore == null ? other$tlsTrustStore != null : !this$tlsTrustStore.equals(other$tlsTrustStore)) {
            return false;
        }
        if (this.isReplyWithStackTraceOnError() != other.isReplyWithStackTraceOnError()) {
            return false;
        }
        return this.isRequestTracingEnabled() == other.isRequestTracingEnabled();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof GRPCServerConfigImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        Optional<String> $publishedRPCHost = this.getPublishedRPCHost();
        result = result * 59 + ($publishedRPCHost == null ? 43 : ((Object)$publishedRPCHost).hashCode());
        Optional<Integer> $publishedRPCPort = this.getPublishedRPCPort();
        result = result * 59 + ($publishedRPCPort == null ? 43 : ((Object)$publishedRPCPort).hashCode());
        result = result * 59 + (this.isAuthorizationEnabled() ? 79 : 97);
        String $userPasswordFile = this.getUserPasswordFile();
        result = result * 59 + ($userPasswordFile == null ? 43 : $userPasswordFile.hashCode());
        result = result * 59 + (this.isTlsEnabled() ? 79 : 97);
        String $tlsCertFile = this.getTlsCertFile();
        result = result * 59 + ($tlsCertFile == null ? 43 : $tlsCertFile.hashCode());
        String $tlsKeyFile = this.getTlsKeyFile();
        result = result * 59 + ($tlsKeyFile == null ? 43 : $tlsKeyFile.hashCode());
        String $tokenSigningKey = this.getTokenSigningKey();
        result = result * 59 + ($tokenSigningKey == null ? 43 : $tokenSigningKey.hashCode());
        Integer $accessTokenTTLInSeconds = this.getAccessTokenTTLInSeconds();
        result = result * 59 + ($accessTokenTTLInSeconds == null ? 43 : ((Object)$accessTokenTTLInSeconds).hashCode());
        String $tlsTrustStore = this.getTlsTrustStore();
        result = result * 59 + ($tlsTrustStore == null ? 43 : $tlsTrustStore.hashCode());
        result = result * 59 + (this.isReplyWithStackTraceOnError() ? 79 : 97);
        result = result * 59 + (this.isRequestTracingEnabled() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class GRPCServerConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        private int port;
        @SuppressFBWarnings(justification="generated code")
        private String publishedRPCHost;
        @SuppressFBWarnings(justification="generated code")
        private Integer publishedRPCPort;
        @SuppressFBWarnings(justification="generated code")
        private boolean authorizationEnabled;
        @SuppressFBWarnings(justification="generated code")
        private String userPasswordFile;
        @SuppressFBWarnings(justification="generated code")
        private boolean tlsEnabled;
        @SuppressFBWarnings(justification="generated code")
        private String tlsCertFile;
        @SuppressFBWarnings(justification="generated code")
        private String tlsKeyFile;
        @SuppressFBWarnings(justification="generated code")
        private String tokenSigningKey;
        @SuppressFBWarnings(justification="generated code")
        private Integer accessTokenTTLInSeconds;
        @SuppressFBWarnings(justification="generated code")
        private String tlsTrustStore;
        @SuppressFBWarnings(justification="generated code")
        private boolean replyWithStackTraceOnError;
        @SuppressFBWarnings(justification="generated code")
        private boolean requestTracingEnabled;

        @SuppressFBWarnings(justification="generated code")
        GRPCServerConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder port(int port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder publishedRPCHost(String publishedRPCHost) {
            this.publishedRPCHost = publishedRPCHost;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder publishedRPCPort(Integer publishedRPCPort) {
            this.publishedRPCPort = publishedRPCPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder authorizationEnabled(boolean authorizationEnabled) {
            this.authorizationEnabled = authorizationEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder userPasswordFile(String userPasswordFile) {
            this.userPasswordFile = userPasswordFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder tlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder tlsCertFile(String tlsCertFile) {
            this.tlsCertFile = tlsCertFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder tlsKeyFile(String tlsKeyFile) {
            this.tlsKeyFile = tlsKeyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder tokenSigningKey(String tokenSigningKey) {
            this.tokenSigningKey = tokenSigningKey;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder accessTokenTTLInSeconds(Integer accessTokenTTLInSeconds) {
            this.accessTokenTTLInSeconds = accessTokenTTLInSeconds;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder tlsTrustStore(String tlsTrustStore) {
            this.tlsTrustStore = tlsTrustStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder replyWithStackTraceOnError(boolean replyWithStackTraceOnError) {
            this.replyWithStackTraceOnError = replyWithStackTraceOnError;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImplBuilder requestTracingEnabled(boolean requestTracingEnabled) {
            this.requestTracingEnabled = requestTracingEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public GRPCServerConfigImpl build() {
            return new GRPCServerConfigImpl(this.port, this.publishedRPCHost, this.publishedRPCPort, this.authorizationEnabled, this.userPasswordFile, this.tlsEnabled, this.tlsCertFile, this.tlsKeyFile, this.tokenSigningKey, this.accessTokenTTLInSeconds, this.tlsTrustStore, this.replyWithStackTraceOnError, this.requestTracingEnabled);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "GRPCServerConfigImpl.GRPCServerConfigImplBuilder(port=" + this.port + ", publishedRPCHost=" + this.publishedRPCHost + ", publishedRPCPort=" + this.publishedRPCPort + ", authorizationEnabled=" + this.authorizationEnabled + ", userPasswordFile=" + this.userPasswordFile + ", tlsEnabled=" + this.tlsEnabled + ", tlsCertFile=" + this.tlsCertFile + ", tlsKeyFile=" + this.tlsKeyFile + ", tokenSigningKey=" + this.tokenSigningKey + ", accessTokenTTLInSeconds=" + this.accessTokenTTLInSeconds + ", tlsTrustStore=" + this.tlsTrustStore + ", replyWithStackTraceOnError=" + this.replyWithStackTraceOnError + ", requestTracingEnabled=" + this.requestTracingEnabled + ")";
        }
    }
}

