/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.checkpoint;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.InMemoryCheckpointStore;
import io.pravega.controller.store.checkpoint.ZKCheckpointStore;
import io.pravega.controller.store.client.StoreClient;
import org.apache.curator.framework.CuratorFramework;

public class CheckpointStoreFactory {
    public static CheckpointStore create(StoreClient storeClient) {
        switch (storeClient.getType()) {
            case InMemory: {
                return new InMemoryCheckpointStore();
            }
            case PravegaTable: 
            case Zookeeper: {
                return new ZKCheckpointStore((CuratorFramework)storeClient.getClient());
            }
        }
        throw new IllegalArgumentException();
    }

    @VisibleForTesting
    public static CheckpointStore createZKStore(CuratorFramework client) {
        return new ZKCheckpointStore(client);
    }

    @VisibleForTesting
    public static CheckpointStore createInMemoryStore() {
        return new InMemoryCheckpointStore();
    }
}

