/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.checkpoint;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Position;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;

class InMemoryCheckpointStore
implements CheckpointStore {
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private static final String SEPARATOR = ":::";
    @GuardedBy(value="$lock")
    private final Map<String, ReaderGroupData> map = new HashMap<String, ReaderGroupData>();

    InMemoryCheckpointStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPosition(String process, String readerGroup, String readerId, Position position) throws CheckpointStoreException {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.getKey(process, readerGroup);
            if (!this.map.containsKey(key)) {
                throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, "ReaderGroup does not exist");
            }
            this.map.get(key).update(readerId, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Position> getPositions(String process, String readerGroup) {
        Object object = this.$lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.map.get(this.getKey(process, readerGroup)).getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReaderGroup(String process, String readerGroup) throws CheckpointStoreException {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.getKey(process, readerGroup);
            if (this.map.containsKey(key)) {
                throw new CheckpointStoreException(CheckpointStoreException.Type.NodeExists, "ReaderGroup exists");
            }
            ReaderGroupData groupData = new ReaderGroupData(ReaderGroupData.State.Active, new HashMap<String, Position>());
            this.map.put(key, groupData);
        }
    }

    @Override
    public Map<String, Position> sealReaderGroup(String process, String readerGroup) throws CheckpointStoreException {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.getKey(process, readerGroup);
            if (this.map.containsKey(key)) {
                ReaderGroupData groupData = this.map.get(key);
                groupData.setState(ReaderGroupData.State.Sealed);
                this.map.put(key, groupData);
                return Collections.unmodifiableMap(groupData.getMap());
            }
            throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, "ReaderGroup does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReaderGroup(String process, String readerGroup) throws CheckpointStoreException {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.getKey(process, readerGroup);
            if (this.map.containsKey(key)) {
                ReaderGroupData groupData = this.map.get(key);
                if (groupData.getState() == ReaderGroupData.State.Active) {
                    throw new CheckpointStoreException(CheckpointStoreException.Type.Active, "ReaderGroup is active.");
                }
                if (!groupData.getMap().isEmpty()) {
                    throw new CheckpointStoreException(CheckpointStoreException.Type.NodeNotEmpty, "ReaderGroup is not empty.");
                }
                this.map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getReaderGroups(String process) {
        Object object = this.$lock;
        synchronized (object) {
            ArrayList<String> list = new ArrayList<String>();
            this.map.entrySet().stream().forEach(pair -> {
                String readerGroup = this.getMatchingReaderGroup((String)pair.getKey(), process);
                if (readerGroup != null) {
                    list.add(readerGroup);
                }
            });
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReader(String process, String readerGroup, String readerId) throws CheckpointStoreException {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.getKey(process, readerGroup);
            if (this.map.containsKey(key)) {
                ReaderGroupData groupData = this.map.get(key);
                if (groupData.getState() == ReaderGroupData.State.Sealed) {
                    throw new CheckpointStoreException(CheckpointStoreException.Type.Sealed, "ReaderGroup is sealed");
                }
                if (groupData.getMap().containsKey(readerId)) {
                    throw new CheckpointStoreException(CheckpointStoreException.Type.NodeExists, "Duplicate readerId");
                }
                groupData.getMap().put(readerId, null);
            }
            this.setPosition(process, readerGroup, readerId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReader(String process, String readerGroup, String readerId) {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.getKey(process, readerGroup);
            if (this.map.containsKey(key)) {
                ReaderGroupData groupData = this.map.get(key);
                groupData.getMap().remove(readerId);
            }
        }
    }

    @Override
    public Set<String> getProcesses() throws CheckpointStoreException {
        return this.map.keySet().stream().map(this::getProcess).collect(Collectors.toSet());
    }

    private String getKey(String process, String readerGroup) {
        return process + SEPARATOR + readerGroup;
    }

    private String getMatchingReaderGroup(String key, String process) {
        String[] splits = key.split(SEPARATOR);
        if (process.equals(splits[0])) {
            return splits[1];
        }
        return null;
    }

    private String getProcess(String key) {
        String[] splits = key.split(SEPARATOR);
        return splits[0];
    }

    private static class ReaderGroupData {
        private State state;
        private Map<String, Position> map;

        void update(String readerId, Position position) throws CheckpointStoreException {
            if (!this.map.containsKey(readerId)) {
                throw new CheckpointStoreException(CheckpointStoreException.Type.NoNode, "Reader does not exist");
            }
            this.map.put(readerId, position);
        }

        @SuppressFBWarnings(justification="generated code")
        public State getState() {
            return this.state;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<String, Position> getMap() {
            return this.map;
        }

        @SuppressFBWarnings(justification="generated code")
        public void setState(State state) {
            this.state = state;
        }

        @SuppressFBWarnings(justification="generated code")
        public void setMap(Map<String, Position> map) {
            this.map = map;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReaderGroupData)) {
                return false;
            }
            ReaderGroupData other = (ReaderGroupData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            State this$state = this.getState();
            State other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            Map<String, Position> this$map = this.getMap();
            Map<String, Position> other$map = other.getMap();
            return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ReaderGroupData;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            State $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            Map<String, Position> $map = this.getMap();
            result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "InMemoryCheckpointStore.ReaderGroupData(state=" + (Object)((Object)this.getState()) + ", map=" + this.getMap() + ")";
        }

        @ConstructorProperties(value={"state", "map"})
        @SuppressFBWarnings(justification="generated code")
        public ReaderGroupData(State state, Map<String, Position> map) {
            this.state = state;
            this.map = map;
        }

        static enum State {
            Active,
            Sealed;

        }
    }
}

