/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.auth.JKSHelper;
import io.pravega.common.auth.ZKTLSUtils;
import io.pravega.controller.store.client.InMemoryStoreClient;
import io.pravega.controller.store.client.PravegaTableStoreClient;
import io.pravega.controller.store.client.StoreClient;
import io.pravega.controller.store.client.StoreClientConfig;
import io.pravega.controller.store.client.ZKClientConfig;
import io.pravega.controller.store.client.ZKStoreClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.RetrySleeper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreClientFactory {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StoreClientFactory.class);
    private static final int CURATOR_MAX_SLEEP_MS = 1000;

    public static StoreClient createStoreClient(StoreClientConfig storeClientConfig) {
        switch (storeClientConfig.getStoreType()) {
            case Zookeeper: {
                return new ZKStoreClient(StoreClientFactory.createZKClient(storeClientConfig.getZkClientConfig().get()));
            }
            case InMemory: {
                return new InMemoryStoreClient();
            }
            case PravegaTable: {
                return new PravegaTableStoreClient(StoreClientFactory.createZKClient(storeClientConfig.getZkClientConfig().get()));
            }
        }
        throw new NotImplementedException(storeClientConfig.getStoreType().toString());
    }

    @VisibleForTesting
    public static StoreClient createInMemoryStoreClient() {
        return new InMemoryStoreClient();
    }

    @VisibleForTesting
    public static StoreClient createZKStoreClient(CuratorFramework client) {
        return new ZKStoreClient(client);
    }

    private static CuratorFramework createZKClient(ZKClientConfig zkClientConfig) {
        CompletableFuture sessionExpiryFuture = new CompletableFuture();
        return StoreClientFactory.createZKClient(zkClientConfig, () -> !sessionExpiryFuture.isDone(), sessionExpiryFuture::complete);
    }

    @VisibleForTesting
    static CuratorFramework createZKClient(ZKClientConfig zkClientConfig, Supplier<Boolean> canRetry, Consumer<Void> expiryHandler) {
        return StoreClientFactory.createZKClient(zkClientConfig, canRetry, expiryHandler, new ZKClientFactory());
    }

    @VisibleForTesting
    static CuratorFramework createZKClient(ZKClientConfig zkClientConfig, Supplier<Boolean> canRetry, Consumer<Void> expiryHandler, ZKClientFactory zkClientFactory) {
        if (zkClientConfig.isSecureConnectionToZooKeeper()) {
            ZKTLSUtils.setSecureZKClientProperties((String)zkClientConfig.getTrustStorePath(), (String)JKSHelper.loadPasswordFrom((String)zkClientConfig.getTrustStorePasswordPath()));
        }
        RetryWrapper retryPolicy = new RetryWrapper((RetryPolicy)new ExponentialBackoffRetry(zkClientConfig.getInitialSleepInterval(), zkClientConfig.getMaxRetries(), 1000), canRetry);
        CuratorFramework zkClient = CuratorFrameworkFactory.builder().connectString(zkClientConfig.getConnectionString()).namespace(zkClientConfig.getNamespace()).zookeeperFactory((ZookeeperFactory)zkClientFactory).retryPolicy((RetryPolicy)retryPolicy).sessionTimeoutMs(zkClientConfig.getSessionTimeoutMs()).build();
        zkClient.start();
        zkClient.getConnectionStateListenable().addListener((client1, newState) -> {
            if (newState.equals((Object)ConnectionState.LOST)) {
                expiryHandler.accept(null);
            }
        });
        return zkClient;
    }

    private static class RetryWrapper
    implements RetryPolicy {
        private final RetryPolicy retryPolicy;
        private final Supplier<Boolean> canRetry;

        public RetryWrapper(RetryPolicy policy, Supplier<Boolean> canRetry) {
            this.retryPolicy = policy;
            this.canRetry = canRetry;
        }

        public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
            return this.canRetry.get() != false && this.retryPolicy.allowRetry(retryCount, elapsedTimeMs, sleeper);
        }
    }

    @VisibleForTesting
    static class ZKClientFactory
    implements ZookeeperFactory {
        @SuppressFBWarnings(justification="generated code")
        private final Object $lock = new Object[0];
        private ZooKeeper client;
        @VisibleForTesting
        private String connectString;
        private int sessionTimeout;
        private boolean canBeReadOnly;

        ZKClientFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
            Object object = this.$lock;
            synchronized (object) {
                if (this.client == null) {
                    Exceptions.checkNotNullOrEmpty((String)connectString, (String)"connectString");
                    Preconditions.checkArgument((sessionTimeout > 0 ? 1 : 0) != 0, (Object)"sessionTimeout should be a positive integer");
                    this.connectString = connectString;
                    this.sessionTimeout = sessionTimeout;
                    this.canBeReadOnly = canBeReadOnly;
                    this.client = new ZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly);
                } else {
                    try {
                        Preconditions.checkArgument((boolean)this.connectString.equals(connectString), (Object)"connectString differs");
                        Preconditions.checkArgument((this.sessionTimeout == sessionTimeout ? 1 : 0) != 0, (Object)"sessionTimeout differs");
                        Preconditions.checkArgument((this.canBeReadOnly == canBeReadOnly ? 1 : 0) != 0, (Object)"canBeReadOnly differs");
                        this.client.register(watcher);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Input argument for new ZooKeeper client ({}, {}, {}) changed with respect to existing client ({}, {}, {}).", new Object[]{connectString, sessionTimeout, canBeReadOnly, this.connectString, this.sessionTimeout, this.canBeReadOnly});
                        this.closeClient(this.client);
                    }
                }
                return this.client;
            }
        }

        private void closeClient(ZooKeeper client) {
            try {
                client.close();
            }
            catch (Exception e) {
                log.error("Exception while attempting to close ZooKeeper client.", (Throwable)e);
            }
        }

        @SuppressFBWarnings(justification="generated code")
        void setConnectString(String connectString) {
            this.connectString = connectString;
        }
    }
}

