/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.host;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.cluster.Host;
import io.pravega.controller.store.host.HostControllerStore;
import io.pravega.controller.store.host.HostStoreException;
import io.pravega.shared.segment.SegmentToContainerMapper;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryHostStore
implements HostControllerStore {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(InMemoryHostStore.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private Map<Host, Set<Integer>> hostContainerMap;
    private final SegmentToContainerMapper segmentMapper;

    InMemoryHostStore(Map<Host, Set<Integer>> hostContainerMap, int containerCount) {
        Preconditions.checkNotNull(hostContainerMap, (Object)"hostContainerMap");
        this.hostContainerMap = hostContainerMap;
        this.segmentMapper = new SegmentToContainerMapper(containerCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Host, Set<Integer>> getHostContainersMap() {
        Object object = this.$lock;
        synchronized (object) {
            return new HashMap<Host, Set<Integer>>(this.hostContainerMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHostContainersMap(Map<Host, Set<Integer>> newMapping) {
        Object object = this.$lock;
        synchronized (object) {
            Preconditions.checkNotNull(newMapping, (Object)"newMapping");
            this.hostContainerMap = new HashMap<Host, Set<Integer>>(newMapping);
        }
    }

    private Host getHostForContainer(int containerId) {
        Optional<Host> host = this.hostContainerMap.entrySet().stream().filter(x -> ((Set)x.getValue()).contains(containerId)).map(x -> (Host)x.getKey()).findAny();
        if (host.isPresent()) {
            log.debug("Found owning host: {} for containerId: {}", (Object)host.get(), (Object)containerId);
            return host.get();
        }
        throw new HostStoreException("Could not find host for container id: " + String.valueOf(containerId));
    }

    @Override
    public int getContainerCount() {
        return this.segmentMapper.getTotalContainerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Host getHostForSegment(String scope, String stream, long segmentId) {
        Object object = this.$lock;
        synchronized (object) {
            String qualifiedName = StreamSegmentNameUtils.getQualifiedStreamSegmentName((String)scope, (String)stream, (long)segmentId);
            return this.getHostForContainer(this.segmentMapper.getContainerId(qualifiedName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Host getHostForTableSegment(String tableName) {
        Object object = this.$lock;
        synchronized (object) {
            return this.getHostForContainer(this.segmentMapper.getContainerId(tableName));
        }
    }
}

