/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.host.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.cluster.Host;
import io.pravega.controller.store.host.HostMonitorConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class HostMonitorConfigImpl
implements HostMonitorConfig {
    private final boolean hostMonitorEnabled;
    private final int hostMonitorMinRebalanceInterval;
    private final int containerCount;
    private final Map<Host, Set<Integer>> hostContainerMap;

    HostMonitorConfigImpl(boolean hostMonitorEnabled, int hostMonitorMinRebalanceInterval, int containerCount, Map<Host, Set<Integer>> hostContainerMap) {
        Exceptions.checkArgument((hostMonitorMinRebalanceInterval > 0 ? 1 : 0) != 0, (String)"hostMonitorMinRebalanceInterval", (String)"Should be positive integer", (Object[])new Object[0]);
        Preconditions.checkArgument((containerCount > 0 ? 1 : 0) != 0, (Object)"containerCount should be positive integer");
        if (!hostMonitorEnabled) {
            Preconditions.checkNotNull(hostContainerMap, (Object)"hostContainerMap");
            int containerCountInMap = hostContainerMap.values().stream().map(x -> x.size()).reduce(0, (x, y) -> x + y);
            Preconditions.checkArgument((containerCount == containerCountInMap ? 1 : 0) != 0, (Object)"containerCount should equal the containers present in hostContainerMap");
        }
        this.hostMonitorEnabled = hostMonitorEnabled;
        this.hostMonitorMinRebalanceInterval = hostMonitorMinRebalanceInterval;
        this.containerCount = containerCount;
        this.hostContainerMap = hostContainerMap;
    }

    @VisibleForTesting
    public static HostMonitorConfig dummyConfig() {
        return new HostMonitorConfigImpl(false, 10, 4, HostMonitorConfigImpl.getHostContainerMap("localhost", 12345, 4));
    }

    public static Map<Host, Set<Integer>> getHostContainerMap(String host, int port, int containerCount) {
        Exceptions.checkNotNullOrEmpty((String)host, (String)"host");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port");
        Preconditions.checkArgument((containerCount > 0 ? 1 : 0) != 0, (Object)"containerCount");
        HashMap<Host, Set<Integer>> hostContainerMap = new HashMap<Host, Set<Integer>>();
        hostContainerMap.put(new Host(host, port, null), IntStream.range(0, containerCount).boxed().collect(Collectors.toSet()));
        return hostContainerMap;
    }

    @SuppressFBWarnings(justification="generated code")
    public static HostMonitorConfigImplBuilder builder() {
        return new HostMonitorConfigImplBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isHostMonitorEnabled() {
        return this.hostMonitorEnabled;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getHostMonitorMinRebalanceInterval() {
        return this.hostMonitorMinRebalanceInterval;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getContainerCount() {
        return this.containerCount;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Map<Host, Set<Integer>> getHostContainerMap() {
        return this.hostContainerMap;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class HostMonitorConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        private boolean hostMonitorEnabled;
        @SuppressFBWarnings(justification="generated code")
        private int hostMonitorMinRebalanceInterval;
        @SuppressFBWarnings(justification="generated code")
        private int containerCount;
        @SuppressFBWarnings(justification="generated code")
        private Map<Host, Set<Integer>> hostContainerMap;

        @SuppressFBWarnings(justification="generated code")
        HostMonitorConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public HostMonitorConfigImplBuilder hostMonitorEnabled(boolean hostMonitorEnabled) {
            this.hostMonitorEnabled = hostMonitorEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public HostMonitorConfigImplBuilder hostMonitorMinRebalanceInterval(int hostMonitorMinRebalanceInterval) {
            this.hostMonitorMinRebalanceInterval = hostMonitorMinRebalanceInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public HostMonitorConfigImplBuilder containerCount(int containerCount) {
            this.containerCount = containerCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public HostMonitorConfigImplBuilder hostContainerMap(Map<Host, Set<Integer>> hostContainerMap) {
            this.hostContainerMap = hostContainerMap;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public HostMonitorConfigImpl build() {
            return new HostMonitorConfigImpl(this.hostMonitorEnabled, this.hostMonitorMinRebalanceInterval, this.containerCount, this.hostContainerMap);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "HostMonitorConfigImpl.HostMonitorConfigImplBuilder(hostMonitorEnabled=" + this.hostMonitorEnabled + ", hostMonitorMinRebalanceInterval=" + this.hostMonitorMinRebalanceInterval + ", containerCount=" + this.containerCount + ", hostContainerMap=" + this.hostContainerMap + ")";
        }
    }
}

