/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.index;

import com.google.common.base.Preconditions;
import io.pravega.controller.store.index.HostIndex;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;

public class InMemoryHostIndex
implements HostIndex {
    private final ConcurrentHashMap<String, ConcurrentSkipListMap<String, byte[]>> hostTable = new ConcurrentHashMap();

    @Override
    public CompletableFuture<Void> addEntity(String hostId, String entity) {
        return this.addEntity(hostId, entity, new byte[0]);
    }

    @Override
    public CompletableFuture<Void> addEntity(String hostId, String entity, byte[] entityData) {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)entity);
        this.hostTable.compute(hostId, (key, listMap) -> {
            if (listMap != null) {
                listMap.put(entity, entityData);
                return listMap;
            }
            ConcurrentSkipListMap<String, byte[]> children = new ConcurrentSkipListMap<String, byte[]>();
            children.put(entity, entityData);
            return children;
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<byte[]> getEntityData(String hostId, String entity) {
        ConcurrentSkipListMap<String, byte[]> value = this.hostTable.get(hostId);
        if (value != null) {
            return CompletableFuture.completedFuture(value.get(entity));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeEntity(String hostId, String entity, boolean deleteEmptyHost) {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)entity);
        this.hostTable.compute(hostId, (key, listMap) -> {
            if (listMap != null) {
                listMap.remove(entity);
                if (deleteEmptyHost && listMap.isEmpty()) {
                    return null;
                }
                return listMap;
            }
            return null;
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeHost(String hostId) {
        Preconditions.checkNotNull((Object)hostId);
        this.hostTable.remove(hostId);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<List<String>> getEntities(String hostId) {
        Preconditions.checkNotNull((Object)hostId);
        ConcurrentSkipListMap<String, byte[]> children = this.hostTable.get(hostId);
        if (children == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.completedFuture(children.keySet().stream().collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Set<String>> getHosts() {
        return CompletableFuture.completedFuture(Collections.unmodifiableSet(this.hostTable.keySet()));
    }
}

