/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.pravega.controller.store.stream.VersionedMetadata;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;

public class Cache {
    private static final int MAX_CACHE_SIZE = 10000;
    private final LoadingCache<CacheKey, CompletableFuture<VersionedMetadata<?>>> cache;

    public Cache(final Function<CacheKey, CompletableFuture<VersionedMetadata<?>>> loader) {
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<CacheKey, CompletableFuture<VersionedMetadata<?>>>(){

            @ParametersAreNonnullByDefault
            public CompletableFuture<VersionedMetadata<?>> load(CacheKey key) {
                return (CompletableFuture)loader.apply(key);
            }
        });
    }

    CompletableFuture<VersionedMetadata<?>> getCachedData(CacheKey key) {
        return ((CompletableFuture)this.cache.getUnchecked((Object)key)).exceptionally(ex -> {
            this.invalidateCache(key);
            throw new CompletionException((Throwable)ex);
        });
    }

    void invalidateCache(CacheKey key) {
        this.cache.invalidate((Object)key);
    }

    public static interface CacheKey {
    }
}

