/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.stream.Scope;
import io.pravega.controller.store.stream.StoreException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InMemoryScope
implements Scope {
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private final String scopeName;
    @GuardedBy(value="$lock")
    private TreeMap<Integer, String> sortedStreamsInScope;
    private HashMap<String, Integer> streamsPositionMap;

    InMemoryScope(String scopeName) {
        this.scopeName = scopeName;
    }

    @Override
    public String getName() {
        return this.scopeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> createScope() {
        Object object = this.$lock;
        synchronized (object) {
            this.sortedStreamsInScope = new TreeMap(Integer::compare);
            this.streamsPositionMap = new HashMap();
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> deleteScope() {
        Object object = this.$lock;
        synchronized (object) {
            this.sortedStreamsInScope.clear();
            this.sortedStreamsInScope = null;
            this.streamsPositionMap.clear();
            this.streamsPositionMap = null;
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> addStreamToScope(String stream) {
        Object object = this.$lock;
        synchronized (object) {
            int next = this.streamsPositionMap.size();
            this.streamsPositionMap.putIfAbsent(stream, next);
            Integer position = this.streamsPositionMap.get(stream);
            this.sortedStreamsInScope.put(position, stream);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> removeStreamFromScope(String stream) {
        Object object = this.$lock;
        synchronized (object) {
            Integer position = this.streamsPositionMap.get(stream);
            if (position != null) {
                this.sortedStreamsInScope.remove(position);
                this.streamsPositionMap.remove(stream);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<List<String>> listStreamsInScope() {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(Lists.newArrayList(this.sortedStreamsInScope.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreams(int limit, String continuationToken, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            String newContinuationToken;
            List limited;
            InMemoryScope inMemoryScope = this;
            synchronized (inMemoryScope) {
                if (this.sortedStreamsInScope == null) {
                    return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, "scope not found"));
                }
                if (Strings.isNullOrEmpty((String)continuationToken)) {
                    limited = this.sortedStreamsInScope.entrySet().stream().limit(limit).collect(Collectors.toList());
                } else {
                    int lastPos = Strings.isNullOrEmpty((String)continuationToken) ? 0 : Integer.parseInt(continuationToken);
                    limited = this.sortedStreamsInScope.tailMap(lastPos, false).entrySet().stream().limit(limit).collect(Collectors.toList());
                }
                newContinuationToken = limited.isEmpty() ? continuationToken : ((Integer)((Map.Entry)limited.get(limited.size() - 1)).getKey()).toString();
            }
            List result = limited.stream().map(Map.Entry::getValue).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new ImmutablePair(result, (Object)newContinuationToken));
        }
    }

    @Override
    public void refresh() {
    }
}

