/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.lang.AtomicInt96;
import io.pravega.common.lang.Int96;
import io.pravega.controller.store.index.InMemoryHostIndex;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.InMemoryScope;
import io.pravega.controller.store.stream.InMemoryStream;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.Scope;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.Stream;
import io.pravega.controller.store.stream.Version;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryStreamMetadataStore
extends AbstractStreamMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(InMemoryStreamMetadataStore.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    @GuardedBy(value="$lock")
    private final Map<String, InMemoryStream> streams = new HashMap<String, InMemoryStream>();
    @GuardedBy(value="$lock")
    private final Map<String, Integer> deletedStreams = new HashMap<String, Integer>();
    @GuardedBy(value="$lock")
    private final Map<String, InMemoryScope> scopes = new HashMap<String, InMemoryScope>();
    @GuardedBy(value="$lock")
    private final Map<Integer, List<String>> bucketedStreams = new HashMap<Integer, List<String>>();
    @GuardedBy(value="$lock")
    private final Map<String, RetentionPolicy> streamPolicyMap = new HashMap<String, RetentionPolicy>();
    private final AtomicInt96 counter;
    private final Executor executor;

    InMemoryStreamMetadataStore(Executor executor) {
        super(new InMemoryHostIndex(), new InMemoryHostIndex());
        this.executor = executor;
        this.counter = new AtomicInt96();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Stream newStream(String scope, String name) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.streams.containsKey(this.scopedStreamName(scope, name))) {
                return this.streams.get(this.scopedStreamName(scope, name));
            }
            return new InMemoryStream(scope, name);
        }
    }

    @Override
    CompletableFuture<Int96> getNextCounter() {
        return CompletableFuture.completedFuture(this.counter.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Boolean> checkScopeExists(String scope) {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(this.scopes.containsKey(scope));
        }
    }

    @Override
    Version getEmptyVersion() {
        return Version.IntVersion.EMPTY;
    }

    @Override
    Version parseVersionData(byte[] data) {
        return Version.IntVersion.fromBytes(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Scope newScope(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                return this.scopes.get(scopeName);
            }
            return new InMemoryScope(scopeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<CreateStreamResponse> createStream(String scopeName, String streamName, StreamConfiguration configuration, long timeStamp, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                InMemoryStream stream = (InMemoryStream)this.getStream(scopeName, streamName, context);
                return this.getSafeStartingSegmentNumberFor(scopeName, streamName).thenCompose(startingSegmentNumber -> stream.create(configuration, timeStamp, (int)startingSegmentNumber).thenCompose(status -> {
                    this.streams.put(this.scopedStreamName(scopeName, streamName), stream);
                    return this.scopes.get(scopeName).addStreamToScope(streamName).thenApply(v -> status);
                }));
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> checkStreamExists(String scopeName, String streamName) {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(this.streams.containsKey(this.scopedStreamName(scopeName, streamName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String streamName) {
        Object object = this.$lock;
        synchronized (object) {
            Integer safeStartingSegmentNumber = this.deletedStreams.get(this.scopedStreamName(scopeName, streamName));
            return CompletableFuture.completedFuture(safeStartingSegmentNumber != null ? safeStartingSegmentNumber + 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> deleteStream(String scopeName, String streamName, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            String scopedStreamName = this.scopedStreamName(scopeName, streamName);
            if (this.scopes.containsKey(scopeName) && this.streams.containsKey(scopedStreamName)) {
                this.streams.remove(scopedStreamName);
                return ((CompletableFuture)this.getCreationTime(scopeName, streamName, context, executor).thenCompose(time -> this.scopes.get(scopeName).removeStreamFromScope(streamName))).thenCompose(v -> super.deleteStream(scopeName, streamName, context, executor));
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, streamName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> startUpdateConfiguration(String scopeName, String streamName, StreamConfiguration configuration, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                String scopeStreamName = this.scopedStreamName(scopeName, streamName);
                if (!this.streams.containsKey(scopeStreamName)) {
                    return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeStreamName));
                }
                return this.streams.get(scopeStreamName).startUpdateConfiguration(configuration);
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Controller.CreateScopeStatus> createScope(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.scopes.containsKey(scopeName)) {
                InMemoryScope scope = new InMemoryScope(scopeName);
                scope.createScope();
                this.scopes.put(scopeName, scope);
                return CompletableFuture.completedFuture(Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.SUCCESS).build());
            }
            return CompletableFuture.completedFuture(Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.SCOPE_EXISTS).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Controller.DeleteScopeStatus> deleteScope(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                return this.scopes.get(scopeName).listStreamsInScope().thenApply(streams -> {
                    if (streams.isEmpty()) {
                        this.scopes.get(scopeName).deleteScope();
                        this.scopes.remove(scopeName);
                        return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SUCCESS).build();
                    }
                    return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SCOPE_NOT_EMPTY).build();
                });
            }
            return CompletableFuture.completedFuture(Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SCOPE_NOT_FOUND).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<String> getScopeConfiguration(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                return CompletableFuture.completedFuture(scopeName);
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<List<String>> listScopes() {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(new ArrayList<String>(this.scopes.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Map<String, StreamConfiguration>> listStreamsInScope(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            InMemoryScope inMemoryScope = this.scopes.get(scopeName);
            if (inMemoryScope != null) {
                return inMemoryScope.listStreamsInScope().thenApply(streams -> {
                    HashMap<String, StreamConfiguration> result = new HashMap<String, StreamConfiguration>();
                    for (String stream : streams) {
                        StreamConfiguration configuration = (StreamConfiguration)Futures.exceptionallyExpecting(this.getConfiguration(scopeName, stream, null, this.executor), e -> e instanceof StoreException.DataNotFoundException, null).join();
                        if (configuration == null) continue;
                        result.put(stream, configuration);
                    }
                    return result;
                });
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> recordLastStreamSegment(String scope, String stream, int lastActiveSegment, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            Integer oldLastActiveSegment = this.deletedStreams.put(this.getScopedStreamName(scope, stream), lastActiveSegment);
            Preconditions.checkArgument((oldLastActiveSegment == null || lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0);
            log.debug("Recording last segment {} for stream {}/{} on deletion.", new Object[]{lastActiveSegment, scope, stream});
            return CompletableFuture.completedFuture(null);
        }
    }

    private String scopedStreamName(String scopeName, String streamName) {
        return scopeName + "/" + streamName;
    }

    @Override
    public void close() throws IOException {
    }

    @VisibleForTesting
    void addStreamObjToScope(String scopeName, String streamName) {
        InMemoryStream stream = (InMemoryStream)this.getStream(scopeName, streamName, null);
        this.streams.put(this.scopedStreamName(scopeName, streamName), stream);
        this.scopes.get(scopeName).addStreamToScope(streamName).join();
    }
}

