/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BitConverter;
import io.pravega.controller.store.stream.PravegaTablesStoreHelper;
import io.pravega.controller.store.stream.PravegaTablesStreamMetadataStore;
import io.pravega.controller.store.stream.Scope;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaTablesScope
implements Scope {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(PravegaTablesScope.class);
    private static final String STREAMS_IN_SCOPE_TABLE_FORMAT = "streamsInScope.#.%s";
    private final String scopeName;
    private final PravegaTablesStoreHelper storeHelper;
    private final AtomicReference<UUID> idRef;

    PravegaTablesScope(String scopeName, PravegaTablesStoreHelper storeHelper) {
        this.scopeName = scopeName;
        this.storeHelper = storeHelper;
        this.idRef = new AtomicReference<Object>(null);
    }

    @Override
    public String getName() {
        return this.scopeName;
    }

    @Override
    public CompletableFuture<Void> createScope() {
        return ((CompletableFuture)Futures.exceptionallyComposeExpecting(this.storeHelper.addNewEntry(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName, this.newId()), (Predicate)PravegaTablesStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, () -> this.storeHelper.createTable(PravegaTablesStreamMetadataStore.SCOPES_TABLE).thenCompose(v -> {
            log.debug("table created {}", (Object)PravegaTablesStreamMetadataStore.SCOPES_TABLE);
            return this.storeHelper.addNewEntryIfAbsent(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName, this.newId());
        })).thenCompose(v -> this.getStreamsInScopeTableName())).thenCompose(tableName -> this.storeHelper.createTable((String)tableName).thenAccept(v -> log.debug("table created {}", tableName)));
    }

    private byte[] newId() {
        byte[] b = new byte[16];
        BitConverter.writeUUID((byte[])b, (int)0, (UUID)UUID.randomUUID());
        return b;
    }

    CompletableFuture<String> getStreamsInScopeTableName() {
        return this.getId().thenApply(id -> StreamSegmentNameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.scopeName, String.format(STREAMS_IN_SCOPE_TABLE_FORMAT, id.toString())}));
    }

    CompletableFuture<UUID> getId() {
        UUID id = this.idRef.get();
        if (Objects.isNull(id)) {
            return this.storeHelper.getEntry(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName, x -> BitConverter.readUUID((byte[])x, (int)0)).thenCompose(entry -> {
                UUID uuid = (UUID)entry.getObject();
                this.idRef.compareAndSet(null, uuid);
                return this.getId();
            });
        }
        return CompletableFuture.completedFuture(id);
    }

    @Override
    public CompletableFuture<Void> deleteScope() {
        return ((CompletableFuture)this.getStreamsInScopeTableName().thenCompose(tableName -> this.storeHelper.deleteTable((String)tableName, true).thenAccept(v -> log.debug("table deleted {}", tableName)))).thenCompose(deleted -> this.storeHelper.removeEntry(PravegaTablesStreamMetadataStore.SCOPES_TABLE, this.scopeName));
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreams(int limit, String continuationToken, Executor executor) {
        ArrayList taken = new ArrayList();
        AtomicReference<String> token = new AtomicReference<String>(continuationToken);
        AtomicBoolean canContinue = new AtomicBoolean(true);
        return this.getStreamsInScopeTableName().thenCompose(streamsInScopeTable -> this.storeHelper.getKeysPaginated((String)streamsInScopeTable, Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode((String)token.get())), limit).thenApply(result -> {
            if (((List)result.getValue()).isEmpty()) {
                canContinue.set(false);
            } else {
                taken.addAll((Collection)result.getValue());
            }
            token.set(Base64.getEncoder().encodeToString(((ByteBuf)result.getKey()).array()));
            return new ImmutablePair((Object)taken, token.get());
        }));
    }

    @Override
    public CompletableFuture<List<String>> listStreamsInScope() {
        ArrayList result = new ArrayList();
        return this.getStreamsInScopeTableName().thenCompose(tableName -> this.storeHelper.getAllKeys((String)tableName).collectRemaining(result::add).thenApply(v -> result));
    }

    @Override
    public void refresh() {
        this.idRef.set(null);
    }

    CompletableFuture<Void> addStreamToScope(String stream) {
        return this.getStreamsInScopeTableName().thenCompose(tableName -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)tableName, stream, this.newId())));
    }

    CompletableFuture<Void> removeStreamFromScope(String stream) {
        return this.getStreamsInScopeTableName().thenCompose(tableName -> Futures.toVoid(this.storeHelper.removeEntry((String)tableName, stream)));
    }

    CompletableFuture<Boolean> checkStreamExistsInScope(String stream) {
        return this.getStreamsInScopeTableName().thenCompose(tableName -> this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry((String)tableName, stream, x -> x).thenApply(v -> true), false));
    }
}

